package java.io;

/**
 * A <code>Flushable</code> is a destination of data that can be flushed. The flush method is invoked to
 * write any buffered output to the underlying stream.
 */
public interface Flushable {

	/**
	 * Flushes this stream by writing any buffered output to the underlying stream.
	 *
	 * @throws IOException
	 *         If an I/O error occurs
	 */
	void flush() throws IOException;
}
