/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

/**
 * Enumerates all MicroUI Image RAW formats.
 */
public enum MicroUIImageFormat {
	/**
	 * Defines an image with the same pixel representation and layout as the LCD memory.
	 */
	MICROUI_IMAGE_FORMAT_DISPLAY,

	/**
	 * Defines an image whose pixel format is ARGB8888.
	 */
	MICROUI_IMAGE_FORMAT_ARGB8888,

	/**
	 * Defines an image whose pixel format is ARGB1555.
	 */
	MICROUI_IMAGE_FORMAT_ARGB1555,

	/**
	 * Defines an image whose pixel format is ARGB4444.
	 */
	MICROUI_IMAGE_FORMAT_ARGB4444,

	/**
	 * Defines an image whose pixel format is ARGB8888 "pre-multiplied": each color component is multiplied by the
	 * opacity.
	 */
	MICROUI_IMAGE_FORMAT_ARGB8888_PRE,

	/**
	 * Defines an image whose pixel format is ARGB1555 pre-multiplied: each color component is multiplied by the
	 * opacity.
	 */
	MICROUI_IMAGE_FORMAT_ARGB1555_PRE,

	/**
	 * Defines an image whose pixel format is ARGB4444 pre-multiplied: each color component is multiplied by the
	 * opacity.
	 */
	MICROUI_IMAGE_FORMAT_ARGB4444_PRE,

	/**
	 * Defines an image whose pixel format is RGB888.
	 */
	MICROUI_IMAGE_FORMAT_RGB888,

	/**
	 * Defines an image whose pixel format is RGB565.
	 */
	MICROUI_IMAGE_FORMAT_RGB565,

	/**
	 * Defines an image whose pixel format is Alpha1.
	 */
	MICROUI_IMAGE_FORMAT_A1,

	/**
	 * Defines an image whose pixel format is Alpha2.
	 */
	MICROUI_IMAGE_FORMAT_A2,

	/**
	 * Defines an image whose pixel format is Alpha4.
	 */
	MICROUI_IMAGE_FORMAT_A4,

	/**
	 * Defines an image whose pixel format is Alpha8.
	 */
	MICROUI_IMAGE_FORMAT_A8,

	/**
	 * Defines an image whose pixel format is Color1.
	 */
	MICROUI_IMAGE_FORMAT_C1,

	/**
	 * Defines an image whose pixel format is Color2.
	 */
	MICROUI_IMAGE_FORMAT_C2,

	/**
	 * Defines an image whose pixel format is Color4.
	 */
	MICROUI_IMAGE_FORMAT_C4,

	/**
	 * Defines an image whose pixel format is Alpha1-Color1.
	 */
	MICROUI_IMAGE_FORMAT_AC11,

	/**
	 * Defines an image whose pixel format is Alpha2-Color2.
	 */
	MICROUI_IMAGE_FORMAT_AC22,

	/**
	 * Defines an image whose pixel format is Alpha4-Color4.
	 */
	MICROUI_IMAGE_FORMAT_AC44,

	/**
	 * Defines an image whose pixel format is a LUT entry on 8 bits and target an ARGB8888 color.
	 */
	MICROUI_IMAGE_FORMAT_LARGB8888,

	/**
	 * Defines an image whose pixel format is a LUT entry on 8 bits and target a RGB888 color.
	 */
	MICROUI_IMAGE_FORMAT_LRGB888,

	/**
	 * Defines an image whose pixel format is Platform dependent.
	 */
	MICROUI_IMAGE_FORMAT_CUSTOM_7,

	/**
	 * Defines an image whose pixel format is Platform dependent.
	 */
	MICROUI_IMAGE_FORMAT_CUSTOM_6,

	/**
	 * Defines an image whose pixel format is Platform dependent.
	 */
	MICROUI_IMAGE_FORMAT_CUSTOM_5,

	/**
	 * Defines an image whose pixel format is Platform dependent.
	 */
	MICROUI_IMAGE_FORMAT_CUSTOM_4,

	/**
	 * Defines an image whose pixel format is Platform dependent.
	 */
	MICROUI_IMAGE_FORMAT_CUSTOM_3,

	/**
	 * Defines an image whose pixel format is Platform dependent.
	 */
	MICROUI_IMAGE_FORMAT_CUSTOM_2,

	/**
	 * Defines an image whose pixel format is Platform dependent.
	 */
	MICROUI_IMAGE_FORMAT_CUSTOM_1,

	/**
	 * Defines an image whose pixel format is Platform dependent.
	 */
	MICROUI_IMAGE_FORMAT_CUSTOM_0,

	/**
	 * Defines an image whose pixel format is MicroUI implementation dependent.
	 */
	MICROUI_IMAGE_FORMAT_INTERNAL,
}
