/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Integer}. This converter creates a clone of the original {@link Integer}.
 */
public class IntegerConverter implements Converter<Integer> {

	@Override
	public Integer convert(Integer arg0, Feature targetOwner) throws IllegalAccessError {
		final int value = arg0.intValue();
		RunnableWithResult<Integer> runnable = new RunnableWithResult<Integer>() {
			@Override
			public Integer runWithResult() {
				return new Integer(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Integer> getType() {
		return Integer.class;
	}

}