/*
 * Java
 *
 * Copyright 2013-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.kf;

/**
 * A {@link Module} is either Kernel or a Feature.
 * It owns a set of classes, objects, threads and stack contexts.
 */
public class Module {

	/**
	 * Gets the name of this module.
	 * @return the internal name
	 */
	public String getName(){
		throw new RuntimeException();
	}

	/**
	 * Gets the identification of this module provider.
	 * @return the module identification.
	 */
	public Principal getProvider(){
		throw new RuntimeException();
	}

	/**
	 * Gets a {@link String} that represents this module version.
	 * @return the module version
	 * @see IncompatibleFeatureException#getExpectedKernelVersion()
	 */
	public String getVersion(){
		throw new RuntimeException();
	}

	/**
	 * Gets a byte sequence that uniquely identifies the current module.
	 * @return this module UID
	 */
	public byte[] getUID(){
		throw new RuntimeException();
	}

	/**
	 * Sets the execution quota allocated to the threads owned by this {@link Module}. This quota is expressed in execution units.<p>
	 * A Thread owned by a {@link Module} which execution quota set to <code>0</code> will never be scheduled.<p>
	 * A Thread owned by a {@link Module} which execution quota set to <code>-1</code> is always eligible to scheduling.<p>
	 * Calling this method induces a global reset of the quantum of all the Modules.
	 * A {@link Module} is created with an execution quota set to <code>-1</code>
	 * @param quota the execution quota to set to this {@link Module} in execution units
	 * @throws IllegalArgumentException if the given quota is lower than <code>-1</code>.
	 */
	public void setExecutionQuota(int quota){
		throw new RuntimeException();
	}

	/**
	 * Gets the execution quota.
	 * @return the quota of this {@link Module} in execution units.
	 */
	public int getExecutionQuota(){
		throw new RuntimeException();
	}

	/**
	 * Gets the current execution counter.
	 * @return the total amount of execution units that has been consumed by threads owned by this {@link Module} since it was started.
	 */
	public long getExecutionCounter(){
		throw new RuntimeException();
	}

}
