/*
 * Copyright 2015-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.style.background;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;

/**
 * A transparent background.
 */
public final class NoBackground implements Background {

	/**
	 * No background singleton to avoid creating several ones.
	 */
	public static final NoBackground NO_BACKGROUND = new NoBackground();

	private NoBackground() {
	}

	@Override
	public boolean isTransparent(int width, int height) {
		return true;
	}

	@Override
	public void apply(GraphicsContext g, int width, int height) {
		g.removeBackgroundColor();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		return (obj == this);
	}

	@Override
	public int hashCode() {
		return 733540869;
	}
}
