/*
 * Copyright (c) 1999, 2012, Oracle and/or its affiliates. All rights reserved.
 * Copyright (C) 2015-2022 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. The Copyright holder(s) designates
 * this particular file as subject to the "Classpath" exception as provided
 * by the Copyright holder(s) in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact the Copyright holder(s) if you need additional information
 * or have any questions.
 * (if Oracle: 500 Oracle Parkway, Redwood Shores, CA 94065 USA or visit www.oracle.com)
 */

package javax.net.ssl;

import java.security.KeyManagementException;
import java.security.SecureRandom;

/**
 * This class defines the <i>Service Provider Interface</i> (<b>SPI</b>) for the <code>SSLContext</code> class.
 *
 * <p>
 * All the abstract methods in this class must be implemented by each cryptographic service provider who wishes to
 * supply the implementation of a particular SSL context.
 *
 * @since 1.4
 * @see SSLContext
 */
public abstract class SSLContextSpi {
	/**
	 * Initializes this context.
	 *
	 * @param km
	 *            the sources of authentication keys
	 * @param tm
	 *            the sources of peer authentication trust decisions
	 * @param sr
	 *            the source of randomness
	 * @throws KeyManagementException
	 *             if this operation fails
	 * @see SSLContext#init(KeyManager [], TrustManager [], SecureRandom)
	 */
	protected abstract void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr)
			throws KeyManagementException;

	/**
	 * Returns a <code>SocketFactory</code> object for this context.
	 *
	 * @return the <code>SocketFactory</code> object
	 * @throws IllegalStateException
	 *             if the SSLContextImpl requires initialization and the <code>engineInit()</code> has not been called
	 * @see javax.net.ssl.SSLContext#getSocketFactory()
	 */
	protected abstract SSLSocketFactory engineGetSocketFactory();

}
