/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.basictool.BitFieldHelper;
import ej.basictool.ThreadUtils;
import ej.bon.Constants;
import ej.microui.MicroUI;
import ej.microui.display.Font;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Painter;
import ej.mwt.Container;
import ej.mwt.Desktop;
import ej.mwt.Trace;
import ej.mwt.style.DefaultStyle;
import ej.mwt.style.Style;
import ej.mwt.style.background.Background;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.outline.Outline;
import ej.mwt.util.OutlineHelper;
import ej.mwt.util.Rectangle;
import ej.mwt.util.Size;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class Widget {
    @Nullable
    private static Map<Widget, Integer> widgetsIds;
    public static final int NO_CONSTRAINT = 0;
    private static final Rectangle SHARED_RECTANGLE;
    private static final int[] EMPTY_INT_ARRAY;
    private static final int ENABLED_SHIFT = 0;
    private static final int ENABLED_MASK = 1;
    private static final int ATTACHED_SHIFT = 1;
    private static final int ATTACHED_MASK = 2;
    private static final int SHOWN_SHIFT = 2;
    private static final int SHOWN_MASK = 4;
    private static final String SHOW_WIDGETS_BOUNDS = "ej.mwt.debug.bounds.enabled";
    private static final String SHOW_WIDGETS_BOUNDS_COLOR = "ej.mwt.debug.bounds.color";
    private static final Style LAZY_DEFAULT_STYLE;
    short x;
    short y;
    short width;
    short height;
    @Nullable
    Object parent;
    private byte flags;
    Style style;
    private int[] classSelectors;

    static {
        SHARED_RECTANGLE = new Rectangle(0, 0, 0, 0);
        EMPTY_INT_ARRAY = new int[0];
        LAZY_DEFAULT_STYLE = new Style(){

            @Override
            public Dimension getDimension() {
                return DefaultStyle.DIMENSION;
            }

            @Override
            public int getHorizontalAlignment() {
                return 0;
            }

            @Override
            public int getVerticalAlignment() {
                return 3;
            }

            @Override
            public Outline getMargin() {
                return DefaultStyle.MARGIN;
            }

            @Override
            public Outline getBorder() {
                return DefaultStyle.BORDER;
            }

            @Override
            public Outline getPadding() {
                return DefaultStyle.PADDING;
            }

            @Override
            public Background getBackground() {
                return DefaultStyle.BACKGROUND;
            }

            @Override
            public int getColor() {
                return 0;
            }

            @Override
            public Font getFont() {
                return Font.getDefaultFont();
            }

            @Override
            public <T> T getExtraObject(int fieldId, Class<T> clazz, T defaultValue) {
                return defaultValue;
            }

            @Override
            public int getExtraInt(int fieldId, int defaultValue) {
                return defaultValue;
            }

            @Override
            public float getExtraFloat(int fieldId, float defaultValue) {
                return defaultValue;
            }
        };
    }

    protected Widget() {
        this(false);
    }

    protected Widget(boolean enabled) {
        this.flags = (byte)BitFieldHelper.setBooleanProperty((int)0, (boolean)enabled, (int)1);
        this.classSelectors = EMPTY_INT_ARRAY;
        this.style = LAZY_DEFAULT_STYLE;
        if (Constants.getBoolean((String)"core.trace.enabled")) {
            Widget.createNewWidget(this);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setPosition(int x, int y) {
        this.x = (short)x;
        this.y = (short)y;
    }

    private void setSize(int width, int height) {
        this.width = (short)Math.max(0, width);
        this.height = (short)Math.max(0, height);
    }

    public Rectangle getContentBounds() {
        Style style = this.style;
        Rectangle contentBounds = new Rectangle(0, 0, this.width, this.height);
        OutlineHelper.applyOutlines(contentBounds, style);
        return contentBounds;
    }

    void layOut(int x, int y, int width, int height) {
        if (Constants.getBoolean((String)"core.trace.enabled")) {
            Trace.TRACER.recordEvent(9, Widget.getWidgetId(this), x, y, width, height);
        }
        Style style = this.style;
        Dimension dimension = style.getDimension();
        Rectangle bounds = Widget.getSharedRectangle(x, y, width, height);
        dimension.layOut(this, bounds);
        this.setPosition(bounds.getX(), bounds.getY());
        this.setSize(bounds.getWidth(), bounds.getHeight());
        this.onLaidOut();
        if (Constants.getBoolean((String)"core.trace.enabled") && !(this instanceof Container)) {
            Trace.TRACER.recordEventEnd(9, Widget.getWidgetId(this));
        }
    }

    protected void onLaidOut() {
    }

    protected void onAttached() {
    }

    protected void onDetached() {
    }

    void setParent(Object parent, boolean attach) {
        this.parent = parent;
        if (attach) {
            this.setAttached();
            if (this.style == LAZY_DEFAULT_STYLE) {
                this.updateStyle();
            }
        }
    }

    void resetParent() {
        this.setDetached();
        this.parent = null;
    }

    public boolean isAttached() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)2);
    }

    void setAttached() {
        if (this.isAttached()) {
            throw new IllegalArgumentException();
        }
        if (Constants.getBoolean((String)"core.trace.enabled")) {
            Trace.TRACER.recordEvent(15, Widget.getWidgetId(this));
        }
        try {
            this.onAttached();
        }
        catch (Exception e) {
            ThreadUtils.handleUncaughtException((Exception)e);
        }
        this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (int)2);
    }

    void setDetached() {
        if (this.isAttached()) {
            this.setHidden();
            if (Constants.getBoolean((String)"core.trace.enabled")) {
                Trace.TRACER.recordEvent(16, Widget.getWidgetId(this));
            }
            try {
                this.onDetached();
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
            }
            this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)2);
        }
    }

    protected void onShown() {
    }

    protected void onHidden() {
    }

    public boolean isShown() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)4);
    }

    void setShown() {
        if (!this.isShown()) {
            if (Constants.getBoolean((String)"core.trace.enabled")) {
                Trace.TRACER.recordEvent(11, Widget.getWidgetId(this));
            }
            try {
                this.onShown();
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
            }
            this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (int)4);
        }
    }

    void setHidden() {
        if (this.isShown()) {
            if (Constants.getBoolean((String)"core.trace.enabled")) {
                Trace.TRACER.recordEvent(12, Widget.getWidgetId(this));
            }
            try {
                this.onHidden();
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
            }
            this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)4);
        }
    }

    public int getAbsoluteX() {
        int absoluteX = this.x;
        Container parent = this.getParent();
        while (parent != null) {
            absoluteX += parent.x + parent.contentX;
            parent = parent.getParent();
        }
        return absoluteX;
    }

    public int getAbsoluteY() {
        int absoluteY = this.y;
        Container parent = this.getParent();
        while (parent != null) {
            absoluteY += parent.y + parent.contentY;
            parent = parent.getParent();
        }
        return absoluteY;
    }

    public boolean isTransparent() {
        Style style = this.style;
        Rectangle bounds = Widget.getSharedRectangle(this.x, this.y, this.width, this.height);
        style.getMargin().apply(bounds);
        return style.getBackground().isTransparent(bounds.getWidth(), bounds.getHeight());
    }

    public boolean containsWidget(Widget widget) {
        Widget ancestor = widget;
        do {
            if (ancestor != this) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean contains(int x, int y) {
        Rectangle bounds = Widget.getSharedRectangle(this.x, this.y, this.width, this.height);
        Style style = this.style;
        style.getMargin().apply(bounds);
        int boundsX = bounds.getX();
        int boundsY = bounds.getY();
        return x >= boundsX && x < boundsX + bounds.getWidth() && y >= boundsY && y < boundsY + bounds.getHeight();
    }

    @Nullable
    public Widget getWidgetAt(int x, int y) {
        if (this.contains(x, y)) {
            return this;
        }
        return null;
    }

    public boolean isEnabled() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)1);
    }

    public void setEnabled(boolean enabled) {
        this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (boolean)enabled, (int)1);
    }

    public void requestLayOut() {
        if (!this.isAttached() || this.width == 0 && this.height == 0) {
            return;
        }
        if (Constants.getBoolean((String)"core.trace.enabled")) {
            Trace.TRACER.recordEvent(3, Widget.getWidgetId(this));
        }
        MicroUI.callSerially((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!Widget.this.isAttached()) {
                    return;
                }
                Widget widget = Widget.this;
                short width = widget.width;
                short height = widget.height;
                Widget.this.computeOptimalSize(width, height);
                Widget.this.layOut(widget.x, widget.y, width, height);
                Widget.this.setShown();
            }
        });
        this.getDesktop().requestRender(this, 0, 0, this.width, this.height);
    }

    void computeOptimalSize(int availableWidth, int availableHeight) {
        if (Constants.getBoolean((String)"core.trace.enabled")) {
            Trace.TRACER.recordEvent(8, Widget.getWidgetId(this), availableWidth, availableHeight);
        }
        Style style = this.style;
        Dimension dimension = style.getDimension();
        Size size = new Size(availableWidth, availableHeight);
        OutlineHelper.applyOutlines(size, style);
        int horizontalOutlines = availableWidth - size.getWidth();
        int verticalOutlines = availableHeight - size.getHeight();
        if (availableWidth == 0) {
            size.setWidth(0);
        }
        if (availableHeight == 0) {
            size.setHeight(0);
        }
        dimension.getAvailableSize(this, availableWidth, availableHeight, size);
        try {
            this.computeContentOptimalSize(size);
        }
        catch (Exception e) {
            ThreadUtils.handleUncaughtException((Exception)e);
        }
        dimension.computeOptimalSize(this, availableWidth, availableHeight, size);
        this.setSize(size.getWidth() + horizontalOutlines, size.getHeight() + verticalOutlines);
        if (Constants.getBoolean((String)"core.trace.enabled")) {
            Trace.TRACER.recordEventEnd(8, Widget.getWidgetId(this));
        }
    }

    protected abstract void computeContentOptimalSize(Size var1);

    public void requestRender() {
        this.requestRender(0, 0, this.width, this.height);
    }

    public void requestRender(int x, int y, int width, int height) {
        if (this.isShown()) {
            this.getDesktop().requestRender(this, x, y, width, height);
        }
    }

    public boolean handleEvent(int event) {
        return false;
    }

    void paint(GraphicsContext g) {
        if (!this.isAttached()) {
            return;
        }
        g.translate((int)this.x, (int)this.y);
        g.intersectClip(0, 0, (int)this.width, (int)this.height);
        if (Constants.getBoolean((String)SHOW_WIDGETS_BOUNDS)) {
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            if (clipWidth == 0 || clipHeight == 0) {
                return;
            }
            int translateX = g.getTranslationX();
            int translateY = g.getTranslationY();
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            if (Constants.getBoolean((String)"core.trace.enabled")) {
                Trace.TRACER.recordEvent(10, Trace.getGraphicsContextId(g), Widget.getWidgetId(this), translateY + clipX, translateY + clipY, clipWidth, clipHeight);
            }
            this.render(g);
            g.setTranslation(translateX, translateY);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
            g.setColor(Constants.getInt((String)SHOW_WIDGETS_BOUNDS_COLOR));
            Painter.drawRectangle((GraphicsContext)g, (int)0, (int)0, (int)this.width, (int)this.height);
        } else {
            if (g.getClipWidth() == 0 || g.getClipHeight() == 0) {
                return;
            }
            if (Constants.getBoolean((String)"core.trace.enabled")) {
                Trace.TRACER.recordEvent(10, Trace.getGraphicsContextId(g), Widget.getWidgetId(this), g.getTranslationX() + g.getClipX(), g.getTranslationY() + g.getClipY(), g.getClipWidth(), g.getClipHeight());
            }
            this.render(g);
        }
        if (Constants.getBoolean((String)"core.trace.enabled")) {
            Trace.TRACER.recordEventEnd(10, Widget.getWidgetId(this));
        }
    }

    public void render(GraphicsContext g) {
        Style style = this.style;
        Size contentSize = new Size(this.width, this.height);
        OutlineHelper.applyOutlinesAndBackground(g, contentSize, style);
        try {
            this.renderContent(g, contentSize.getWidth(), contentSize.getHeight());
        }
        catch (Exception e) {
            ThreadUtils.handleUncaughtException((Exception)e);
        }
    }

    protected abstract void renderContent(GraphicsContext var1, int var2, int var3);

    @Nullable
    public Container getParent() {
        Object parent = this.parent;
        if (parent instanceof Container) {
            return (Container)parent;
        }
        return null;
    }

    public Desktop getDesktop() {
        Object parent = this.parent;
        assert (parent != null) : "This widget (" + Widget.printClassname(this) + ") is not attached to any desktop.";
        if (parent instanceof Desktop) {
            return (Desktop)((Object)parent);
        }
        return ((Container)parent).getDesktop();
    }

    static String printClassname(Widget widget) {
        return widget.getClass().getSimpleName();
    }

    @Nullable
    Desktop getDesktopOrNull() {
        Object parent = this.parent;
        if (parent instanceof Desktop) {
            return (Desktop)((Object)parent);
        }
        if (parent != null) {
            return ((Container)parent).getDesktopOrNull();
        }
        return null;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style newStyle) {
        this.style = newStyle;
    }

    public void updateStyle() {
        Desktop desktop;
        if (Constants.getBoolean((String)"core.trace.enabled")) {
            Trace.TRACER.recordEvent(7, Widget.getWidgetId(this));
        }
        if ((desktop = this.getDesktopOrNull()) != null) {
            Style newStyle = desktop.getStylesheet().getStyle(this);
            this.setStyle(newStyle);
        }
        if (Constants.getBoolean((String)"core.trace.enabled") && !(this instanceof Container)) {
            Trace.TRACER.recordEventEnd(7, Widget.getWidgetId(this));
        }
    }

    public boolean hasClassSelector(int classSelector) {
        return ArrayTools.getIndex((int[])this.classSelectors, (int)classSelector) != -1;
    }

    public void addClassSelector(int classSelector) {
        this.classSelectors = ArrayTools.add((int[])this.classSelectors, (int)classSelector);
    }

    public void removeClassSelector(int classSelector) {
        this.classSelectors = ArrayTools.remove((int[])this.classSelectors, (int)classSelector);
    }

    public void setClassSelectors(int[] classSelectors) {
        this.classSelectors = (int[])classSelectors.clone();
    }

    public void removeAllClassSelectors() {
        this.classSelectors = EMPTY_INT_ARRAY;
    }

    public boolean isInState(int state) {
        return false;
    }

    static Rectangle getSharedRectangle(int x, int y, int width, int height) {
        SHARED_RECTANGLE.setBounds(x, y, width, height);
        return SHARED_RECTANGLE;
    }

    private static Map<Widget, Integer> getWidgetsIds() {
        if (widgetsIds == null) {
            widgetsIds = new WeakHashMap<Widget, Integer>();
        }
        return widgetsIds;
    }

    static int getWidgetId(Widget widget) {
        Integer id = Widget.getWidgetsIds().get(widget);
        if (id != null) {
            return id;
        }
        return -1;
    }

    private static void createNewWidget(Widget widget) {
        int id = ++Trace.currentId;
        Widget.getWidgetsIds().put(widget, id);
        Trace.TRACER.recordEvent(0, id, widget.getClass().hashCode());
        if (Constants.getBoolean((String)"ej.mwt.debug.log.trace.enabled")) {
            Trace.LOGGER.info("Widget " + widget + " gets ID " + id);
        }
    }
}

