/*
 * Decompiled with CFR 0.152.
 */
package ej.cbor;

import ej.cbor.ErrorMessage;

public class CborType {
    private static final ErrorMessage ERR = ErrorMessage.getDefault();
    private final int major;
    private final int additional;

    private CborType(int major, int additional) {
        this.major = major;
        this.additional = additional;
    }

    public static String getName(int mt) throws IllegalArgumentException {
        switch (mt) {
            case 4: {
                return "array";
            }
            case 2: {
                return "byte string";
            }
            case 7: {
                return "float/simple value";
            }
            case 5: {
                return "map";
            }
            case 1: {
                return "negative integer";
            }
            case 6: {
                return "tag";
            }
            case 3: {
                return "text string";
            }
            case 0: {
                return "unsigned integer";
            }
        }
        throw new IllegalArgumentException(ERR.messageAt(20, mt));
    }

    public static CborType valueOf(int i) {
        return new CborType((i & 0xFF) >>> 5, i & 0x1F);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CborType other = (CborType)obj;
        return this.major == other.major && this.additional == other.additional;
    }

    public int getAdditionalInfo() {
        return this.additional;
    }

    public int getMajorType() {
        return this.major;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.additional;
        result = 31 * result + this.major;
        return result;
    }

    public boolean isBreakAllowed() {
        return this.major == 4 || this.major == 2 || this.major == 5 || this.major == 3;
    }

    public boolean isEqualType(CborType other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException(ERR.messageAt(21, new Object[0]));
        }
        return this.major == other.major;
    }

    public boolean isEqualType(int encoded) {
        return this.major == (encoded & 0xFF) >>> 5;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CborType.getName(this.major)).append('(').append(this.additional).append(')');
        return sb.toString();
    }
}

