/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.impl;

import ej.rcommand.CommandSender;
import ej.rcommand.RemoteCommandListener;
import ej.rcommand.RemoteCommandManager;
import ej.rcommand.RemoteConnection;
import ej.rcommand.RemoteConnectionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultRemoteCommandManager
implements RemoteCommandManager {
    private static final String THREAD_NAME_PREFIX = "Rcommand ";
    private static final String UNKNOWN_CONNNECTION = "unknown";
    private final HashMap<String, RemoteCommandListener> listeners = new HashMap();
    private final Map<RemoteConnection, CommandReader> readers = new HashMap<RemoteConnection, CommandReader>();
    private final boolean registerOverwrite;

    public DefaultRemoteCommandManager(boolean overwrite) {
        this.registerOverwrite = overwrite;
    }

    public DefaultRemoteCommandManager() {
        this(false);
    }

    private Logger getLogger() {
        return Logger.getLogger(DefaultRemoteCommandManager.class.getName());
    }

    @Override
    public void registerListener(RemoteCommandListener listener) throws IllegalStateException {
        String[] commands;
        for (String command : commands = listener.getManagedCommands()) {
            if (!this.registerOverwrite && this.listeners.containsKey(command)) {
                throw new IllegalStateException("Duplicate listener for " + command);
            }
            this.listeners.put(command, listener);
        }
    }

    protected RemoteCommandListener getListenerFor(String command) {
        return this.listeners.get(command);
    }

    @Override
    public void startReading(RemoteConnection connection) {
        this.startReading(connection, UNKNOWN_CONNNECTION, null);
    }

    @Override
    public void startReading(RemoteConnection connection, RemoteConnectionListener listener) {
        this.startReading(connection, UNKNOWN_CONNNECTION, listener);
    }

    @Override
    public void startReading(RemoteConnection connection, String connectionName) {
        this.startReading(connection, connectionName, null);
    }

    @Override
    public synchronized void startReading(RemoteConnection connection, String connectionName, RemoteConnectionListener listener) {
        CommandReader reader = new CommandReader(connection, listener);
        this.readers.put(connection, reader);
        Thread thread = new Thread(reader);
        thread.setName(THREAD_NAME_PREFIX + connectionName);
        thread.start();
    }

    @Override
    public synchronized void stopReading(RemoteConnection connection) {
        CommandReader reader = this.readers.remove(connection);
        if (reader != null) {
            reader.stopReading();
        }
    }

    public void onError(RemoteConnection connection) {
        this.stopReading(connection);
    }

    @Override
    public synchronized void stopAll() {
        for (CommandReader reader : this.readers.values()) {
            if (reader == null) continue;
            reader.stopReading();
        }
        this.readers.clear();
    }

    @Override
    public Collection<? extends CommandSender> getCommandSenders(String command) {
        return this.readers.keySet();
    }

    private class CommandReader
    implements Runnable {
        private final RemoteConnection connection;
        private final RemoteConnectionListener listener;
        private volatile boolean running;

        public CommandReader(RemoteConnection connection, RemoteConnectionListener listener) {
            this.connection = connection;
            this.listener = listener;
            this.running = true;
        }

        @Override
        public void run() {
            RemoteConnection connection = this.connection;
            if (this.listener != null) {
                this.listener.startRead();
            }
            while (this.running) {
                try {
                    String command = connection.readCommand();
                    DefaultRemoteCommandManager.this.getLogger().finer("Command received: " + command);
                    RemoteCommandListener listener = DefaultRemoteCommandManager.this.getListenerFor(command);
                    if (listener != null) {
                        listener.commandReceived(connection, connection, command);
                        connection.skipParameters();
                        continue;
                    }
                    if (!this.running) continue;
                    List<Object> params = connection.readParameters();
                    connection.skipParameters();
                    DefaultRemoteCommandManager.this.getLogger().severe("Command not managed: " + command + this.toString(params));
                }
                catch (IllegalArgumentException e) {
                    DefaultRemoteCommandManager.this.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    try {
                        connection.skipParameters();
                    }
                    catch (IOException e1) {}
                }
                catch (IOException e) {
                    if (!this.running) break;
                    DefaultRemoteCommandManager.this.onError(connection);
                    break;
                }
            }
            if (this.listener != null) {
                this.listener.stopRead();
            }
        }

        public void stopReading() {
            this.running = false;
            this.connection.close();
        }

        public String toString(List<Object> params) {
            StringBuilder sb = new StringBuilder("(");
            for (Object param : params) {
                if (param.getClass().isArray()) {
                    byte[] array = (byte[])param;
                    sb.append("byte[" + array.length + "], ");
                    continue;
                }
                if (param instanceof String) {
                    String s = (String)param;
                    sb.append("\"" + s + "\", ");
                    continue;
                }
                sb.append(param.toString());
            }
            if (sb.length() > 2) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(')');
            return sb.toString();
        }
    }
}

