/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline.border;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Painter;
import ej.mwt.style.outline.Outline;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

public class FlexibleRectangularMulticoloredBorder
implements Outline {
    private final char top;
    private final char bottom;
    private final char left;
    private final char right;
    private final int colorTop;
    private final int colorBottom;
    private final int colorLeft;
    private final int colorRight;

    public FlexibleRectangularMulticoloredBorder(int top, int colorTop, int right, int colorRight, int bottom, int colorBottom, int left, int colorLeft) {
        this.top = (char)XMath.limit((int)top, (int)0, (int)65535);
        this.right = (char)XMath.limit((int)right, (int)0, (int)65535);
        this.bottom = (char)XMath.limit((int)bottom, (int)0, (int)65535);
        this.left = (char)XMath.limit((int)left, (int)0, (int)65535);
        this.colorTop = colorTop;
        this.colorRight = colorRight;
        this.colorBottom = colorBottom;
        this.colorLeft = colorLeft;
    }

    public int getColorTop() {
        return this.colorTop;
    }

    public int getColorBottom() {
        return this.colorBottom;
    }

    public int getColorLeft() {
        return this.colorLeft;
    }

    public int getColorRight() {
        return this.colorRight;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    @Override
    public void apply(Outlineable outlineable) {
        outlineable.removeOutline(this.left, this.top, this.right, this.bottom);
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        int width = size.getWidth();
        int height = size.getHeight();
        g.setColor(this.colorTop);
        int topThickness = this.getTop();
        Painter.fillRectangle((GraphicsContext)g, (int)0, (int)0, (int)width, (int)topThickness);
        g.setColor(this.colorBottom);
        int bottomThickness = this.getBottom();
        Painter.fillRectangle((GraphicsContext)g, (int)0, (int)(height - bottomThickness), (int)width, (int)bottomThickness);
        g.setColor(this.colorLeft);
        int leftThickness = this.getLeft();
        Painter.fillRectangle((GraphicsContext)g, (int)0, (int)0, (int)leftThickness, (int)height);
        g.setColor(this.colorRight);
        int rightThickness = this.getRight();
        Painter.fillRectangle((GraphicsContext)g, (int)(width - rightThickness), (int)0, (int)rightThickness, (int)height);
        size.removeOutline(leftThickness, topThickness, rightThickness, bottomThickness);
        g.translate(leftThickness, topThickness);
        g.intersectClip(0, 0, size.getWidth(), size.getHeight());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof FlexibleRectangularMulticoloredBorder) {
            FlexibleRectangularMulticoloredBorder border = (FlexibleRectangularMulticoloredBorder)obj;
            return this.top == border.top && this.bottom == border.bottom && this.left == border.left && this.right == border.right && this.colorTop == border.colorTop && this.colorBottom == border.colorBottom && this.colorLeft == border.colorLeft && this.colorRight == border.colorRight;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.top * this.bottom * this.left * this.right * this.colorTop * this.colorBottom * this.colorLeft * this.colorRight;
    }
}

