/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.basictool.ThreadUtils;
import ej.microui.display.GraphicsContext;
import ej.mwt.Widget;
import ej.mwt.style.Style;
import ej.mwt.util.OutlineHelper;
import ej.mwt.util.Rectangle;

public abstract class Container
extends Widget {
    private static final Widget[] EMPTY_WIDGET_ARRAY = new Widget[0];
    char contentX;
    char contentY;
    char contentWidth;
    char contentHeight;
    private Widget[] children = EMPTY_WIDGET_ARRAY;

    protected void addChild(Widget child) {
        child.setParent(this, this.isAttached());
        this.children = (Widget[])ArrayTools.add((Object[])this.children, (Object)child);
    }

    protected void removeChild(Widget child) {
        Object[] children = this.children;
        this.children = (Widget[])ArrayTools.remove((Object[])children, (Object)child);
        if (this.children.length != children.length) {
            child.resetParent();
        }
    }

    protected void insertChild(Widget child, int index) {
        Object[] children = this.children;
        if (index >= 0 && index <= children.length) {
            child.setParent(this, this.isAttached());
        }
        this.children = (Widget[])ArrayTools.insert((Object[])children, (int)index, (Object)child);
    }

    protected void replaceChild(int index, Widget child) {
        Widget[] children = this.children;
        Widget oldChild = children[index];
        if (child != oldChild) {
            if (child.getParent() == null) {
                oldChild.resetParent();
            }
            child.setParent(this, this.isAttached());
            children[index] = child;
        }
    }

    protected void removeAllChildren() {
        Widget[] children;
        Widget[] widgetArray = children = this.children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            child.resetParent();
            ++n2;
        }
        this.children = EMPTY_WIDGET_ARRAY;
    }

    protected void changeChildIndex(Widget child, int index) {
        Object[] children = this.children;
        int currentIndex = ArrayTools.getIndex((Object[])children, (Object)child);
        if (currentIndex == -1) {
            throw new IllegalArgumentException();
        }
        if (currentIndex != index) {
            if (index < currentIndex) {
                System.arraycopy(children, index, children, index + 1, currentIndex - index);
            } else {
                System.arraycopy(children, currentIndex + 1, children, currentIndex, index - currentIndex);
            }
            children[index] = child;
        }
    }

    @Override
    void setAttached() {
        super.setAttached();
        Widget[] widgetArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            child.setAttached();
            ++n2;
        }
    }

    @Override
    void setDetached() {
        super.setDetached();
        Widget[] widgetArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            child.setDetached();
            ++n2;
        }
    }

    @Override
    void setShown() {
        super.setShown();
        this.setShownChildren();
    }

    @Override
    void setHidden() {
        super.setHidden();
        this.setHiddenChildren();
    }

    protected void setShownChildren() {
        Widget[] widgetArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            child.setShown();
            ++n2;
        }
    }

    protected void setHiddenChildren() {
        Widget[] widgetArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            child.setHidden();
            ++n2;
        }
    }

    protected void setShownChild(Widget child) {
        assert (child.parent == this);
        child.setShown();
    }

    protected void setHiddenChild(Widget child) {
        assert (child.parent == this);
        child.setHidden();
    }

    @Override
    @Nullable
    public Widget getWidgetAt(int x, int y) {
        if (!this.contains(x, y)) {
            return null;
        }
        int relX = x - this.x - this.contentX;
        int relY = y - this.y - this.contentY;
        Widget[] children = this.children;
        int i = children.length - 1;
        while (i >= 0) {
            Widget at = children[i].getWidgetAt(relX, relY);
            if (at != null) {
                return at;
            }
            --i;
        }
        return this;
    }

    public Widget getChild(int index) {
        Widget child = this.children[index];
        assert (child != null);
        return child;
    }

    public int getChildIndex(Widget child) {
        Widget[] children = this.children;
        int length = children.length;
        int i = 0;
        while (i < length) {
            if (child == children[i]) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    protected Widget[] getChildren() {
        return this.children;
    }

    public int getChildrenCount() {
        return this.children.length;
    }

    protected void computeChildOptimalSize(Widget child, int availableWidth, int availableHeight) {
        assert (child.parent == this);
        child.computeOptimalSize(availableWidth, availableHeight);
    }

    @Override
    void layOut(int x, int y, int width, int height) {
        super.layOut(x, y, width, height);
        Style style = this.style;
        assert (style != null);
        Rectangle rectangle = Container.getSharedRectangle(0, 0, this.getWidth(), this.getHeight());
        OutlineHelper.applyOutlines(rectangle, style);
        this.contentX = (char)rectangle.getX();
        this.contentY = (char)rectangle.getY();
        this.contentWidth = (char)rectangle.getWidth();
        this.contentHeight = (char)rectangle.getHeight();
        try {
            this.layOutChildren(this.contentWidth, this.contentHeight);
        }
        catch (Exception e) {
            ThreadUtils.handleUncaughtException((Exception)e);
        }
    }

    protected abstract void layOutChildren(int var1, int var2);

    protected void layOutChild(Widget child, int x, int y, int width, int height) {
        assert (child.parent == this);
        child.layOut(x, y, width, height);
    }

    public int getContentX() {
        return this.contentX;
    }

    public int getContentY() {
        return this.contentY;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    @Override
    protected void renderContent(GraphicsContext g, int contentWidth, int contentHeight) {
        int translateX = g.getTranslationX();
        int translateY = g.getTranslationY();
        int x = g.getClipX();
        int y = g.getClipY();
        int width = g.getClipWidth();
        int height = g.getClipHeight();
        Widget[] children = this.children;
        int childrenLength = children.length;
        int i = 0;
        while (i < childrenLength) {
            Widget child = children[i];
            assert (child != null);
            this.renderChild(child, g);
            if (i < childrenLength - 1) {
                g.setTranslation(translateX, translateY);
                g.setClip(x, y, width, height);
            }
            ++i;
        }
    }

    protected void renderChild(Widget child, GraphicsContext g) {
        assert (child.parent == this);
        child.paint(g);
    }

    @Override
    public void updateStyle() {
        super.updateStyle();
        Widget[] widgetArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            child.updateStyle();
            ++n2;
        }
    }

    @Override
    public Rectangle getContentBounds() {
        return new Rectangle(this.contentX, this.contentY, this.contentWidth, this.contentHeight);
    }
}

