/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.annotation.Nullable;
import ej.hoka.http.Config;
import ej.hoka.http.HaltException;
import ej.hoka.http.HttpRequest;
import ej.hoka.http.HttpResponse;
import ej.hoka.http.HttpServer;
import ej.hoka.http.MethodNotAllowedException;
import ej.hoka.http.RouteHandler;
import ej.hoka.http.RouteNotFoundException;
import ej.hoka.http.encoding.ContentEncoding;
import ej.hoka.http.encoding.EncodingRegistry;
import ej.hoka.http.encoding.HttpUnsupportedEncodingException;
import ej.hoka.log.HokaLogger;
import ej.hoka.tcp.TcpServer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;

class Worker
implements Runnable {
    private static final String UNKNOWN_ADDRESS = "0.0.0.0";
    private static final String HTML_BR = "<br/>";
    private static final String HTML_PARAGRAPH_START = "<p>";
    private static final String HTML_PARAGRAPH_CLOSE = "</p>";
    private final TcpServer server;
    private final RouteHandler routesHandler;
    private final boolean devMode;
    private final boolean strictAcceptEncoding;
    private final EncodingRegistry encodingRegistry;
    @Nullable
    private final String notFoundErrorMessage;
    private final String notFoundErrorContentType;
    private final String internalServerErrorMessage;
    private final String internalServerErrorContentType;

    Worker(TcpServer server, RouteHandler routesHandler, EncodingRegistry encodingRegistry, boolean strictAcceptEncoding, String notFoundErrorMessage, String notFoundErrorContentType, String internalServerErrorMessage, String internalServerErrorContentType, boolean devMode) {
        this.server = server;
        this.routesHandler = routesHandler;
        this.encodingRegistry = encodingRegistry;
        this.strictAcceptEncoding = strictAcceptEncoding;
        this.notFoundErrorMessage = notFoundErrorMessage;
        this.notFoundErrorContentType = notFoundErrorContentType;
        this.internalServerErrorMessage = internalServerErrorMessage;
        this.internalServerErrorContentType = internalServerErrorContentType;
        this.devMode = devMode;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConnection(Socket connection) {
        InetAddress address = connection.getInetAddress();
        int hash = connection.hashCode();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream(), Config.getInstance().getBufferSize());
                try {
                    try (OutputStream outputStream = connection.getOutputStream();){
                        this.doProcess(inputStream, outputStream, address, hash);
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStream == null) throw throwable;
                    ((InputStream)inputStream).close();
                    throw throwable;
                }
                ((InputStream)inputStream).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            HokaLogger.instance.error(String.valueOf(connection.hashCode()) + "\t" + (address != null ? address.toString() : UNKNOWN_ADDRESS), e);
        }
    }

    private void doProcess(InputStream inputStream, OutputStream outputStream, @Nullable InetAddress address, int hash) throws IOException {
        HttpRequest request = null;
        HttpResponse response = new HttpResponse();
        ContentEncoding encodingHandler = null;
        try {
            String accept;
            request = new HttpRequest(inputStream, this.encodingRegistry);
            if (this.strictAcceptEncoding && (encodingHandler = this.encodingRegistry.getAcceptEncodingHandler(accept = request.getHeader("accept-encoding"))) == null) {
                throw new HttpUnsupportedEncodingException("406 Not Acceptable", accept);
            }
            this.routesHandler.process(request, response);
        }
        catch (HaltException e) {
            response.setStatus(e.getStatus());
            response.setData(e.getBody());
        }
        catch (MethodNotAllowedException e) {
            this.handleMethodNotAllowedError(response, e);
        }
        catch (RouteNotFoundException routeNotFoundException) {
            this.handleNotFoundError(response);
        }
        catch (IllegalArgumentException e) {
            this.handleError(response, "400 Bad Request", e);
        }
        catch (HttpUnsupportedEncodingException e) {
            this.handleError(response, "406 Not Acceptable", e);
        }
        catch (SocketTimeoutException e) {
            this.handleError(response, "408 Request Timeout", e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleInternalServerError(response, e);
        }
        response.addHeader("connection", "close");
        String msg = this.createResponseLogMsg(request == null ? "" : request.getURI(), response.getStatus(), hash, Worker.getHostAdressString(address));
        HokaLogger.instance.debug(msg);
        response.sendResponse(outputStream, encodingHandler, this.encodingRegistry, Config.getInstance().getBufferSize());
    }

    private static String getHostAdressString(@Nullable InetAddress address) {
        return address != null ? address.getHostAddress() : UNKNOWN_ADDRESS;
    }

    private String createResponseLogMsg(String uri, String status, int connection, String address) {
        StringBuilder msg = new StringBuilder();
        msg.append(connection);
        msg.append("\t");
        msg.append(address);
        msg.append("\t");
        msg.append(new Date());
        msg.append("\t");
        msg.append(uri);
        msg.append("\t");
        msg.append(status);
        return msg.toString();
    }

    private void handleMethodNotAllowedError(HttpResponse response, MethodNotAllowedException e) {
        response.setStatus("405 Method Not Allowed");
        response.setData("");
        response.addHeader("allow", e.getAllowHeader());
    }

    private void handleInternalServerError(HttpResponse response, Throwable e) {
        response.setStatus("500 Internal Server Error");
        if (this.devMode) {
            response.setMimeType("text/html");
            response.setData(Worker.createHtmlError("500 Internal Server Error", e.getMessage(), e));
        } else {
            response.setMimeType(this.internalServerErrorContentType);
            response.setData(this.internalServerErrorMessage);
        }
    }

    private void handleError(HttpResponse response, String status, Exception e) {
        response.setStatus(status);
        if (this.devMode) {
            response.setMimeType("text/html");
            response.setData(Worker.createHtmlError(status, e.getMessage(), e));
        } else {
            response.setData("");
        }
    }

    private void handleNotFoundError(HttpResponse response) {
        response.setStatus("404 Not Found");
        response.setMimeType(this.notFoundErrorContentType);
        String errorMessage = this.notFoundErrorMessage;
        if (errorMessage == null || errorMessage.isEmpty()) {
            response.setData("");
        } else {
            response.setData(errorMessage);
        }
    }

    private static String createHtmlError(String status, @Nullable String msg, @Nullable Throwable t) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><head><title>");
        buffer.append(status);
        buffer.append("</title></head><body>");
        buffer.append("<h3>").append(status).append("</h3>");
        if (msg != null && !msg.isEmpty()) {
            buffer.append(HTML_PARAGRAPH_START).append(msg).append(HTML_PARAGRAPH_CLOSE);
        }
        if (t != null) {
            buffer.append("<hr/>");
            buffer.append("<b>Exception:</b>");
            buffer.append(HTML_PARAGRAPH_START).append(Worker.getHtmlExceptionStackTrace(t)).append(HTML_PARAGRAPH_CLOSE);
        }
        buffer.append("</body></html>");
        return buffer.toString();
    }

    private static String getHtmlExceptionStackTrace(Throwable t) {
        StringBuilder fullMessageBuilder = new StringBuilder();
        String message = t.getMessage();
        if (message != null) {
            fullMessageBuilder.append(message);
            fullMessageBuilder.append(HTML_BR);
        }
        StackTraceElement[] stackTrace = t.getStackTrace();
        int i = 0;
        String className = "java.lang";
        while (i < stackTrace.length && stackTrace[i].getClassName().startsWith(className)) {
            ++i;
        }
        if (i > 0 && i - 1 < stackTrace.length) {
            fullMessageBuilder.append(stackTrace[i - 1].toString()).append(HTML_BR);
        }
        className = HttpServer.class.getName();
        while (i < stackTrace.length && !stackTrace[i].getClassName().equals(className)) {
            fullMessageBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;at ").append(stackTrace[i].toString()).append(HTML_BR);
            ++i;
        }
        return fullMessageBuilder.toString();
    }
}

