/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.util.debug;

import ej.mwt.Container;
import ej.mwt.Desktop;
import ej.mwt.Widget;

public class HierarchyInspector {
    private HierarchyInspector() {
    }

    public static int countNumberOfContainers(Widget widget) {
        int number = 0;
        if (widget instanceof Container) {
            ++number;
            Container container = (Container)widget;
            int numChildren = container.getChildrenCount();
            int i = 0;
            while (i < numChildren) {
                Widget child = container.getChild(i);
                number += HierarchyInspector.countNumberOfContainers(child);
                ++i;
            }
        }
        return number;
    }

    public static int countNumberOfWidgets(Widget widget) {
        int number = 0;
        if (widget instanceof Container) {
            Container container = (Container)widget;
            int numChildren = container.getChildrenCount();
            int i = 0;
            while (i < numChildren) {
                Widget child = container.getChild(i);
                number += HierarchyInspector.countNumberOfWidgets(child);
                ++i;
            }
        } else {
            ++number;
        }
        return number;
    }

    public static int countMaxDepth(Widget widget) {
        return HierarchyInspector.countMaxDepth(widget, 0);
    }

    private static int countMaxDepth(Widget widget, int currentDepth) {
        int maxDepth = currentDepth;
        if (widget instanceof Container) {
            Container container = (Container)widget;
            int numChildren = container.getChildrenCount();
            int i = 0;
            while (i < numChildren) {
                Widget child = container.getChild(i);
                int childDepth = HierarchyInspector.countMaxDepth(child, currentDepth + 1);
                maxDepth = Math.max(maxDepth, childDepth);
                ++i;
            }
        }
        return maxDepth;
    }

    public static String hierarchyToString(Widget widget) {
        StringBuilder builder = new StringBuilder();
        HierarchyInspector.appendHierarchyRecursive(builder, widget, 0);
        return builder.toString();
    }

    private static void appendHierarchyRecursive(StringBuilder builder, Widget widget, int depth) {
        HierarchyInspector.appendDepth(builder, depth);
        HierarchyInspector.appendElement(builder, widget);
        builder.append('\n');
        if (widget instanceof Container) {
            HierarchyInspector.appendChildrenHierarchy(builder, (Container)widget, depth);
        }
    }

    private static void appendChildrenHierarchy(StringBuilder builder, Container container, int depth) {
        int childrenCount = container.getChildrenCount();
        int i = 0;
        while (i < childrenCount) {
            Widget child = container.getChild(i);
            HierarchyInspector.appendHierarchyRecursive(builder, child, depth + 1);
            ++i;
        }
    }

    static StringBuilder appendDepth(StringBuilder builder, int depth) {
        while (depth > 1) {
            builder.append('|').append(' ').append(' ');
            --depth;
        }
        if (depth > 0) {
            builder.append('+').append('-').append('-');
        }
        return builder;
    }

    public static String pathToWidgetToString(Widget widget) {
        return HierarchyInspector.pathToWidgetToString(widget, '>');
    }

    public static String pathToWidgetToString(Widget widget, char separator) {
        StringBuilder builder = new StringBuilder();
        if (widget.isAttached()) {
            Desktop desktop = widget.getDesktop();
            HierarchyInspector.appendElement(builder, desktop);
            HierarchyInspector.appendSeparator(builder, separator);
        }
        HierarchyInspector.pathToWidgetRecursive(builder, widget, separator);
        return builder.toString();
    }

    private static void pathToWidgetRecursive(StringBuilder builder, Widget widget, char separator) {
        Container parent = widget.getParent();
        if (parent != null) {
            HierarchyInspector.pathToWidgetRecursive(builder, (Widget)parent, separator);
            HierarchyInspector.appendSeparator(builder, separator);
        }
        HierarchyInspector.appendElement(builder, widget);
    }

    static StringBuilder appendElement(StringBuilder builder, Object object) {
        int length;
        String simpleName = object.getClass().getSimpleName();
        if (simpleName.charAt((length = simpleName.length()) - 1) == '@' && simpleName.charAt(0) != '@') {
            simpleName = simpleName.substring(0, length - 1);
        }
        builder.append(simpleName);
        return builder;
    }

    private static void appendSeparator(StringBuilder builder, char separator) {
        builder.append(' ').append(separator).append(' ');
    }
}

