/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.util.debug;

import ej.mwt.Container;
import ej.mwt.Widget;
import ej.widget.util.debug.HierarchyInspector;

public class BoundsInspector {
    private static final String ABSOLUTE = "absolute:";

    private BoundsInspector() {
    }

    public static String boundsToString(Widget widget) {
        StringBuilder builder = new StringBuilder();
        BoundsInspector.appendBounds(builder, widget);
        return builder.toString();
    }

    public static String boundsRecursiveToString(Widget widget) {
        StringBuilder builder = new StringBuilder();
        BoundsInspector.appendBoundsRecursive(builder, widget, 0);
        return builder.toString();
    }

    private static void appendBoundsRecursive(StringBuilder builder, Widget widget, int depth) {
        HierarchyInspector.appendDepth(builder, depth);
        BoundsInspector.appendBounds(builder, widget);
        builder.append('\n');
        if (widget instanceof Container) {
            BoundsInspector.appendChildrenBounds(builder, (Container)widget, depth);
        }
    }

    private static void appendChildrenBounds(StringBuilder builder, Container container, int depth) {
        int childrenCount = container.getChildrenCount();
        int i = 0;
        while (i < childrenCount) {
            Widget child = container.getChild(i);
            BoundsInspector.appendBoundsRecursive(builder, child, depth + 1);
            ++i;
        }
    }

    private static void appendBounds(StringBuilder builder, Widget widget) {
        HierarchyInspector.appendElement(builder, widget).append(':').append(' ').append(widget.getX()).append(',').append(widget.getY()).append(' ').append(widget.getWidth()).append('x').append(widget.getHeight()).append(' ').append('(').append(ABSOLUTE).append(' ').append(widget.getAbsoluteX()).append(',').append(widget.getAbsoluteY()).append(')');
    }
}

