/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import java.awt.geom.AffineTransform;

public class MatrixHelper {
    private MatrixHelper() {
    }

    public static float[] create() {
        return new float[9];
    }

    public static float[] createIdentity() {
        float[] matrix = MatrixHelper.create();
        MatrixHelper.identity(matrix);
        return matrix;
    }

    public static float[] create(float x, float y) {
        float[] matrix = MatrixHelper.create();
        MatrixHelper.reset(matrix, x, y);
        return matrix;
    }

    public static float[] create(float[] matrix) {
        float[] m = MatrixHelper.create();
        MatrixHelper.copy(m, matrix);
        return m;
    }

    public static void identity(float[] matrix) {
        MatrixHelper.reset(matrix, 0.0f, 0.0f);
    }

    public static void reset(float[] matrix, float x, float y) {
        matrix[0] = 1.0f;
        matrix[1] = 0.0f;
        matrix[2] = x;
        matrix[3] = 0.0f;
        matrix[4] = 1.0f;
        matrix[5] = y;
        matrix[6] = 0.0f;
        matrix[7] = 0.0f;
        matrix[8] = 1.0f;
    }

    public static void copy(float[] dest, float[] src) {
        System.arraycopy(src, 0, dest, 0, dest.length);
    }

    public static void translate(float[] matrix, float x, float y) {
        matrix[2] = matrix[0] * x + matrix[1] * y + matrix[2];
        matrix[5] = matrix[3] * x + matrix[4] * y + matrix[5];
        matrix[8] = matrix[6] * x + matrix[7] * y + matrix[8];
    }

    public static void scale(float[] matrix, float scaleX, float scaleY) {
        matrix[0] = matrix[0] * scaleX;
        matrix[1] = matrix[1] * scaleY;
        matrix[3] = matrix[3] * scaleX;
        matrix[4] = matrix[4] * scaleY;
        matrix[6] = matrix[6] * scaleX;
        matrix[7] = matrix[7] * scaleY;
    }

    public static void rotate(float[] matrix, float degrees) {
        double angleRadians = Math.toRadians(degrees);
        float cosAngle = (float)Math.cos(angleRadians);
        float sinAngle = (float)Math.sin(angleRadians);
        float tmp = cosAngle * matrix[0] + sinAngle * matrix[1];
        matrix[1] = cosAngle * matrix[1] - sinAngle * matrix[0];
        matrix[0] = tmp;
        tmp = cosAngle * matrix[3] + sinAngle * matrix[4];
        matrix[4] = cosAngle * matrix[4] - sinAngle * matrix[3];
        matrix[3] = tmp;
        tmp = cosAngle * matrix[6] + sinAngle * matrix[7];
        matrix[7] = cosAngle * matrix[7] - sinAngle * matrix[6];
        matrix[6] = tmp;
    }

    public static void concatenate(float[] matrix, float[] other) {
        float[] temp = MatrixHelper.create();
        temp[0] = matrix[0] * other[0] + matrix[1] * other[3] + matrix[2] * other[6];
        temp[1] = matrix[0] * other[1] + matrix[1] * other[4] + matrix[2] * other[7];
        temp[2] = matrix[0] * other[2] + matrix[1] * other[5] + matrix[2] * other[8];
        temp[3] = matrix[3] * other[0] + matrix[4] * other[3] + matrix[5] * other[6];
        temp[4] = matrix[3] * other[1] + matrix[4] * other[4] + matrix[5] * other[7];
        temp[5] = matrix[3] * other[2] + matrix[4] * other[5] + matrix[5] * other[8];
        temp[6] = matrix[6] * other[0] + matrix[7] * other[3] + matrix[8] * other[6];
        temp[7] = matrix[6] * other[1] + matrix[7] * other[4] + matrix[8] * other[7];
        temp[8] = matrix[6] * other[2] + matrix[7] * other[5] + matrix[8] * other[8];
        MatrixHelper.copy(matrix, temp);
    }

    public static AffineTransform getAffineTransform(float[] matrix, float tx, float ty) {
        AffineTransform t = new AffineTransform();
        t.translate(tx, ty);
        t.concatenate(new AffineTransform(new float[]{matrix[0], matrix[3], matrix[1], matrix[4], matrix[2], matrix[5]}));
        return t;
    }
}

