/*
 * Decompiled with CFR 0.152.
 */
package ej.observable;

import ej.annotation.Nullable;
import ej.observable.Observer;

public class SimpleObservable {
    @Nullable
    private Observer observer = null;
    private boolean changed;

    @Nullable
    public Observer getObserver() {
        return this.observer;
    }

    public void setObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observer = observer;
    }

    public void unsetObserver(Observer observer) {
        if (observer == this.observer) {
            this.observer = null;
        }
    }

    public void unsetObserver() {
        this.observer = null;
    }

    protected void setChanged() {
        this.changed = true;
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void notifyObserver() {
        if (!this.changed) {
            return;
        }
        this.clearChanged();
        Observer observer = this.observer;
        if (observer != null) {
            observer.update();
        }
    }
}

