/*
 * Decompiled with CFR 0.152.
 */
package ej.json;

import ej.json.JSONException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class JSONReader {
    public static final Object NULL = new Null();
    private static final int ERROR_MISSING_VALUE = 0;
    private static final int ERROR_UNTERMINATED_STRING = 1;
    private static final int ERROR_UNCLOSED_COMMENT = 2;
    private static final int ERROR_WRONG_KEY_SEP = 3;
    private static final int ERROR_UNEXPECTED_TOKEN = 4;
    private static final int ERROR_MISSING_KEY = 5;
    private static final int NOT_SET = -1;
    private final InputStreamReader is;
    private int current = -1;

    public JSONReader(InputStream is) {
        this.is = new InputStreamReader(is);
    }

    public char peek() throws JSONException {
        char c = this.nextClean();
        if (c == ',') {
            c = this.nextClean();
        }
        this.back(c);
        return c;
    }

    private void back(char c) {
        this.current = c;
    }

    private char next() throws JSONException {
        int i = this.current;
        if (i != -1) {
            this.current = -1;
            return (char)i;
        }
        try {
            i = this.is.read();
            if (i != -1) {
                return (char)i;
            }
            return '\u0000';
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private String next(int n) throws JSONException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(this.next());
        }
        return sb.toString();
    }

    private char nextClean() throws JSONException {
        char c;
        block4: while (true) {
            if ((c = this.next()) == '/') {
                c = this.next();
                switch (c) {
                    case '/': {
                        while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c = this.next()) == '\u0000') {
                                throw this.syntaxError(2);
                            }
                            if (c != '*') continue;
                            c = this.next();
                            if (c == '/') continue block4;
                            this.back(c);
                        }
                    }
                    default: {
                        this.back(c);
                        return '/';
                    }
                }
            }
            if (c == '#') {
                while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                }
                continue;
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    private String nextString(char quote) throws JSONException {
        StringBuffer sb = new StringBuffer();
        block13: while (true) {
            char c = this.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError(1);
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            sb.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    sb.append(c);
                    continue block13;
                }
            }
            if (c == quote) {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    public String nextKey() throws JSONException {
        String result;
        Object o = this.nextValue();
        if (o == null) {
            throw this.syntaxError(5);
        }
        try {
            result = (String)o;
        }
        catch (ClassCastException e) {
            throw this.syntaxError(5);
        }
        char c = this.nextClean();
        if (c == '=') {
            c = this.next();
            if (c != '>') {
                this.back(c);
            }
        } else if (c != ':') {
            throw this.syntaxError(3);
        }
        return result;
    }

    public void arrayStart() throws JSONException {
        char c = this.nextClean();
        if (c == ',') {
            c = this.nextClean();
        }
        if (c != '[') {
            throw this.syntaxError(4);
        }
    }

    public void arrayEnd() throws JSONException {
        if (this.nextClean() != ']') {
            throw this.syntaxError(4);
        }
    }

    public void mapStart() throws JSONException {
        char c = this.nextClean();
        if (c == ',') {
            c = this.nextClean();
        }
        if (c != '{') {
            throw this.syntaxError(4);
        }
    }

    public void mapEnd() throws JSONException {
        if (this.nextClean() != '}') {
            throw this.syntaxError(4);
        }
    }

    public Object nextValue() throws JSONException {
        char c = this.nextClean();
        if (c == ',') {
            c = this.nextClean();
        }
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                this.back(c);
                return null;
            }
            case '[': {
                this.back(c);
                return null;
            }
        }
        StringBuffer sb = new StringBuffer();
        char b = c;
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = this.next();
        }
        this.back(c);
        String s = sb.toString().trim();
        if (s.equals("")) {
            throw this.syntaxError(0);
        }
        if (s.toLowerCase().equals("true")) {
            return Boolean.TRUE;
        }
        if (s.toLowerCase().equals("false")) {
            return Boolean.FALSE;
        }
        if (s.toLowerCase().equals("null")) {
            return NULL;
        }
        if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
            if (b == '0') {
                if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(s.substring(2), 16));
                    }
                    catch (Exception e) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(s, 8));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            try {
                return Integer.valueOf(s);
            }
            catch (Exception e) {
                try {
                    return new Long(Long.parseLong(s));
                }
                catch (Exception f) {
                    try {
                        return Double.valueOf(s);
                    }
                    catch (Exception g) {
                        return s;
                    }
                }
            }
        }
        return s;
    }

    private JSONException syntaxError(int code) {
        return new JSONException("E=" + code);
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

