/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.paint;

import ej.microvg.MatrixHelper;
import ej.microvg.paint.PaintVisitor;
import ej.microvg.paint.VGPaint;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class LinearGradient
implements VGPaint {
    private final Color[] colors;
    private final float[] fractions;
    private final AffineTransform at;

    public LinearGradient(Color[] colors, float[] fractions, float[] matrix) {
        this(colors, fractions, MatrixHelper.getAffineTransform(matrix, 0.0f, 0.0f));
    }

    public LinearGradient(Color[] colors, float[] fractions, float xStart, float yStart, float xEnd, float yEnd) {
        this(colors, fractions, LinearGradient.transformMatrix(MatrixHelper.createIdentity(), xStart, yStart, xEnd, yEnd));
    }

    public LinearGradient(Color[] colors, float[] fractions, float[] matrix, float xStart, float yStart, float xEnd, float yEnd) {
        this(colors, fractions, LinearGradient.transformMatrix((float[])matrix.clone(), xStart, yStart, xEnd, yEnd));
    }

    public LinearGradient(Color[] colors, float[] fractions, AffineTransform matrix) {
        if (colors.length != fractions.length) {
            throw new IllegalArgumentException();
        }
        this.colors = colors;
        this.fractions = fractions;
        this.at = matrix;
    }

    @Override
    public LinearGradient apply(PaintVisitor transformer) {
        int length = this.colors.length;
        Color[] oldColors = this.colors;
        Color[] newColors = new Color[length];
        int i = 0;
        while (i < length) {
            newColors[i] = new Color(transformer.visitColor(oldColors[i].getRGB()), true);
            ++i;
        }
        AffineTransform at = transformer.visitTransform(this.at);
        return new LinearGradient(newColors, this.fractions, at);
    }

    @Override
    public Paint getPaint() {
        Point2D.Float gradientOrigin = new Point2D.Float();
        Point2D.Float gradientEnd = new Point2D.Float();
        this.at.transform(new Point2D.Float(0.0f, 0.0f), gradientOrigin);
        this.at.transform(new Point2D.Float(1.0f, 0.0f), gradientEnd);
        return new LinearGradientPaint(gradientOrigin, gradientEnd, this.fractions, this.colors);
    }

    private static float[] transformMatrix(float[] matrix, float x0, float y0, float x1, float y1) {
        MatrixHelper.translate(matrix, x0, y0);
        MatrixHelper.rotate(matrix, LinearGradient.getGradientAngle(x0, y0, x1, y1));
        MatrixHelper.scale(matrix, Math.max(LinearGradient.getGradientLength(x0, y0, x1, y1), 0.1f), 1.0f);
        return matrix;
    }

    private static float getGradientLength(float x0, float y0, float x1, float y1) {
        return (float)Math.sqrt(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0));
    }

    private static float getGradientAngle(float x0, float y0, float x1, float y1) {
        double angle = Math.atan2(y1 - y0, x1 - x0);
        return (float)Math.toDegrees(angle);
    }
}

