/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

import ej.microvg.image.ImageDecoder;
import ej.microvg.image.pathdata.PathData;
import ej.microvg.image.pathdata.TwoArraysPathData;
import ej.microvg.paint.LinearGradient;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NemaImageDecoder
implements ImageDecoder {
    private static final byte CMD_CLOSE = 0;
    private static final byte CMD_MOVE = 1;
    private static final byte CMD_MOVE_REL = 17;
    private static final byte CMD_LINE = 2;
    private static final byte CMD_LINE_REL = 18;
    private static final byte CMD_QUAD = 5;
    private static final byte CMD_QUAD_REL = 21;
    private static final byte CMD_CUBIC = 6;
    private static final byte CMD_CUBIC_REL = 22;
    private static final int FILL_NON_ZERO = 1;
    private static final int FILL_EVEN_ODD = 2;

    @Override
    public PathData decodePath(ByteBuffer is) {
        is.getFloat();
        is.getFloat();
        is.getFloat();
        is.getFloat();
        char nbCommands = is.getChar();
        char nbParams = is.getChar();
        ByteBuffer params = ByteBuffer.wrap(is.array(), is.position(), nbParams * 4).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer commands = ByteBuffer.wrap(is.array(), is.position() + nbParams * 4, nbCommands * '\u0001').order(ByteOrder.LITTLE_ENDIAN);
        return new TwoArraysPathData(commands, params);
    }

    @Override
    public LinearGradient decodeGradient(ByteBuffer is) {
        float x0 = is.getFloat();
        float y0 = is.getFloat();
        float x1 = is.getFloat();
        float y1 = is.getFloat();
        int count = is.getInt();
        float[] positions = new float[count];
        int i = 0;
        while (i < count) {
            float pos;
            positions[i] = pos = is.getFloat();
            ++i;
        }
        Color[] colors = new Color[count];
        int i2 = 0;
        while (i2 < count) {
            float red = is.getFloat() / 255.0f;
            float green = is.getFloat() / 255.0f;
            float blue = is.getFloat() / 255.0f;
            float alpha = is.getFloat() / 255.0f;
            colors[i2] = new Color(red, green, blue, alpha);
            ++i2;
        }
        return new LinearGradient(colors, positions, x0, y0, x1, y1);
    }

    @Override
    public int decodeCommand(int encodedCommand) {
        switch (encodedCommand) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 18: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 21: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 22: 
        }
        return 8;
    }

    @Override
    public int decodeFillRule(int rule) {
        return 2 == rule ? 1 : 0;
    }

    @Override
    public int decodeColor(int color) {
        int blue = color >> 16 & 0xFF;
        int red = (color & 0xFF) << 16;
        color &= 0xFF00FF00;
        color |= red;
        return color |= blue;
    }
}

