/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import ej.annotation.Nullable;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.Period;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.AbstractChronology;
import java.time.chrono.Era;
import java.time.chrono.IsoEra;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class IsoChronology
extends AbstractChronology
implements Serializable {
    public static final IsoChronology INSTANCE = new IsoChronology();

    private IsoChronology() {
    }

    @Override
    public String getId() {
        return "ISO";
    }

    @Override
    @Nullable
    public String getCalendarType() {
        return "iso8601";
    }

    @Override
    public LocalDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public LocalDate date(int prolepticYear, int month, int dayOfMonth) {
        return LocalDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public LocalDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public LocalDate dateYearDay(int prolepticYear, int dayOfYear) {
        return LocalDate.ofYearDay(prolepticYear, dayOfYear);
    }

    @Override
    public LocalDate dateEpochDay(long epochDay) {
        return LocalDate.ofEpochDay(epochDay);
    }

    @Override
    public LocalDate date(TemporalAccessor temporal) {
        return LocalDate.from(temporal);
    }

    public LocalDateTime localDateTime(TemporalAccessor temporal) {
        return LocalDateTime.from(temporal);
    }

    public ZonedDateTime zonedDateTime(TemporalAccessor temporal) {
        return ZonedDateTime.from(temporal);
    }

    public ZonedDateTime zonedDateTime(Instant instant, ZoneId zone) {
        return ZonedDateTime.ofInstant(instant, zone);
    }

    @Override
    public LocalDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public LocalDate dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    @Override
    public LocalDate dateNow(Clock clock) {
        return this.date(LocalDate.now(clock));
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return (prolepticYear & 3L) == 0L && (prolepticYear % 100L != 0L || prolepticYear % 400L == 0L);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof IsoEra)) {
            throw new ClassCastException("Era must be IsoEra");
        }
        return era == IsoEra.CE ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public IsoEra eraOf(int eraValue) {
        return IsoEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        ArrayList<Era> eras = new ArrayList<Era>(2);
        eras.add(IsoEra.BCE);
        eras.add(IsoEra.CE);
        return eras;
    }

    @Override
    @Nullable
    public LocalDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (LocalDate)super.resolveDate(fieldValues, resolverStyle);
    }

    @Override
    void resolveProlepticMonth(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long pMonth = fieldValues.remove(ChronoField.PROLEPTIC_MONTH);
        if (pMonth != null) {
            long month = pMonth;
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.PROLEPTIC_MONTH.checkValidValue(month);
            }
            long year = month / 12L;
            if ((month ^ 0xCL) < 0L && year * 12L != month) {
                --year;
            }
            long moy = month - year * 12L;
            this.addFieldValue(fieldValues, ChronoField.MONTH_OF_YEAR, moy + 1L);
            this.addFieldValue(fieldValues, ChronoField.YEAR, year);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    LocalDate resolveYearOfEra(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long yoeLong = fieldValues.remove(ChronoField.YEAR_OF_ERA);
        if (yoeLong != null) {
            Long eraLong;
            long yoe = yoeLong;
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.YEAR_OF_ERA.checkValidValue(yoe);
            }
            if ((eraLong = fieldValues.remove(ChronoField.ERA)) == null) {
                Long year = fieldValues.get(ChronoField.YEAR);
                if (resolverStyle == ResolverStyle.STRICT) {
                    if (year != null) {
                        this.addFieldValue(fieldValues, ChronoField.YEAR, year > 0L ? yoe : 1L - yoe);
                        return null;
                    } else {
                        fieldValues.put(ChronoField.YEAR_OF_ERA, yoeLong);
                    }
                    return null;
                } else {
                    this.addFieldValue(fieldValues, ChronoField.YEAR, year == null || year > 0L ? yoe : 1L - yoe);
                }
                return null;
            } else {
                long era = eraLong;
                if (era == 1L) {
                    this.addFieldValue(fieldValues, ChronoField.YEAR, yoe);
                    return null;
                } else {
                    if (era != 0L) throw new DateTimeException("Invalid value for era: " + eraLong);
                    this.addFieldValue(fieldValues, ChronoField.YEAR, 1L - yoe);
                }
            }
            return null;
        } else {
            if (!fieldValues.containsKey(ChronoField.ERA)) return null;
            Long era = fieldValues.get(ChronoField.ERA);
            assert (era != null);
            ChronoField.ERA.checkValidValue(era);
        }
        return null;
    }

    @Override
    LocalDate resolveYMD(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        Long yearLong = fieldValues.remove(ChronoField.YEAR);
        assert (yearLong != null);
        int y = ChronoField.YEAR.checkValidIntValue(yearLong);
        Long moyLong = fieldValues.remove(ChronoField.MONTH_OF_YEAR);
        assert (moyLong != null);
        long months = moyLong - 1L;
        Long domLong = fieldValues.remove(ChronoField.DAY_OF_MONTH);
        assert (domLong != null);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long days = domLong - 1L;
            return LocalDate.of(y, 1, 1).plusMonths(months).plusDays(days);
        }
        int moy = ChronoField.MONTH_OF_YEAR.checkValidIntValue(moyLong);
        int dom = ChronoField.DAY_OF_MONTH.checkValidIntValue(domLong);
        if (resolverStyle == ResolverStyle.SMART) {
            if (moy == 4 || moy == 6 || moy == 9 || moy == 11) {
                dom = Math.min(dom, 30);
            } else if (moy == 2) {
                dom = Math.min(dom, Month.FEBRUARY.length(Year.isLeap(y)));
            }
        }
        return LocalDate.of(y, moy, dom);
    }

    @Override
    public ValueRange range(ChronoField field) {
        return field.range();
    }

    @Override
    public Period period(int years, int months, int days) {
        return Period.of(years, months, days);
    }
}

