/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogManager {
    private static final LogManager GLOBAL_LOG_MANAGER = LogManager.newLogManager();
    final Logger rootLogger;
    private final PackedMap<String, WeakReference<Logger>> namedLoggers = new PackedMap();

    protected LogManager() {
        this.rootLogger = new RootLogger();
        Handler[] handlerArray = this.getDefaultHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            assert (handler != null);
            this.rootLogger.addHandler(handler);
            ++n2;
        }
        this.addLogger(this.rootLogger);
    }

    private static LogManager newLogManager() {
        return new LogManager();
    }

    private Handler[] getDefaultHandlers() {
        String property = System.getProperty("handlers");
        Handler[] handlers = new Handler[]{};
        if (property != null) {
            try {
                Class<?> classes = Class.forName(property);
                Handler handler = (Handler)classes.newInstance();
                handlers = new Handler[]{handler};
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return handlers;
    }

    private Level getDefaultLevel() {
        Level[] predefined;
        Level defaultLevel = Level.INFO;
        String property = System.getProperty(".level");
        Level[] levelArray = predefined = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
        int n = predefined.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            if (level.getName().equals(property)) {
                defaultLevel = level;
                break;
            }
            ++n2;
        }
        return defaultLevel;
    }

    public static LogManager getLogManager() {
        return GLOBAL_LOG_MANAGER;
    }

    public boolean addLogger(Logger logger) {
        String name = logger.getName();
        String lowerCaseName = name.toLowerCase();
        WeakReference weakLogger = (WeakReference)this.namedLoggers.get((Object)lowerCaseName);
        if (weakLogger != null && weakLogger.get() != null) {
            return false;
        }
        this.namedLoggers.put((Object)lowerCaseName, new WeakReference<Logger>(logger));
        return true;
    }

    @Nullable
    public Logger getLogger(String name) {
        String lowerCaseName = name.toLowerCase();
        WeakReference weakLogger = (WeakReference)this.namedLoggers.get((Object)lowerCaseName);
        if (weakLogger == null) {
            return null;
        }
        return (Logger)weakLogger.get();
    }

    public Enumeration<String> getLoggerNames() {
        return new Enumeration<String>(){
            private final Iterator<String> iterator;
            {
                this.iterator = LogManager.this.namedLoggers.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return this.iterator.next();
            }
        };
    }

    private class RootLogger
    extends Logger {
        protected RootLogger() {
            super("", null);
            this.setLevel(LogManager.this.getDefaultLevel());
        }
    }
}

