/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tool.classextender.helper;

import ej.basictool.annotation.Extend;
import javassist.CtMethod;

public class MethodHelper {
    public final CtMethod node;

    public MethodHelper(CtMethod node) {
        this.node = node;
    }

    public boolean isStatic() {
        return MethodHelper.hasStaticModifier(this.node.getModifiers());
    }

    public boolean keepStatic() {
        try {
            Extend extension = (Extend)this.node.getAnnotation(Extend.class);
            return extension == null ? false : extension.isStatic();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean hasStaticModifier(int modifiers) {
        return (modifiers & 8) == 8;
    }

    public int removeStatic() {
        this.node.setModifiers(this.node.getModifiers() & 0xFFFFFFF7);
        return this.node.getModifiers();
    }

    public String removeFirstArgumentFromDescriptor() {
        String descriptor = this.node.getMethodInfo().getDescriptor();
        String extendedClassName = this.getExtendedClassType();
        if (descriptor.startsWith("()")) {
            throw new IllegalStateException(String.valueOf(this.node.getName()) + " should have at least one argument of type " + extendedClassName);
        }
        String firstArgDescritptor = this.getFirstArgumentDescriptor();
        if (!extendedClassName.equals(this.getArgumentObjectType(firstArgDescritptor))) {
            throw new IllegalStateException(String.valueOf(this.node.getName()) + " should have first argument of type " + extendedClassName);
        }
        StringBuilder newDescriptor = new StringBuilder();
        newDescriptor.append('(');
        newDescriptor.append(descriptor.substring(firstArgDescritptor.length() + 1));
        this.node.getMethodInfo().setDescriptor(newDescriptor.toString());
        return newDescriptor.toString();
    }

    private String getExtendedClassType() {
        return this.node.getDeclaringClass().getName();
    }

    private String getFirstArgumentDescriptor() {
        int firstArgEnd;
        String descriptor = this.node.getMethodInfo().getDescriptor();
        switch (descriptor.charAt(1)) {
            case ')': {
                throw new IllegalStateException();
            }
            case 'L': {
                firstArgEnd = descriptor.indexOf(59) + 1;
                break;
            }
            default: {
                firstArgEnd = 2;
            }
        }
        return descriptor.substring(1, firstArgEnd);
    }

    private String getArgumentObjectType(String descriptor) {
        if (descriptor.length() < 2) {
            return null;
        }
        String type = descriptor.substring(1, descriptor.length() - 1);
        return type.replace('/', '.');
    }
}

