/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.WeakHashMap;

public abstract class DateFormat {
    private static final int DATE_FLAG = 2;
    private static final int TIME_FLAG = 1;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    private static final WeakHashMap<String, DateFormat> FormaterPoll = new WeakHashMap();
    protected Calendar calendar = Calendar.getInstance();

    protected DateFormat() {
    }

    public abstract String format(Date var1);

    public static final DateFormat getTimeInstance() {
        return DateFormat.get(2, 0, 1);
    }

    public static final DateFormat getTimeInstance(int style) {
        return DateFormat.get(style, 0, 1);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.get(0, 2, 2);
    }

    public static final DateFormat getDateInstance(int style) {
        return DateFormat.get(0, style, 2);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.get(2, 2, 3);
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return DateFormat.get(timeStyle, dateStyle, 3);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public void setCalendar(Calendar newCalendar) {
        if (newCalendar == null) {
            throw new NullPointerException();
        }
        this.calendar = newCalendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    private static DateFormat get(int timeStyle, int dateStyle, int flags) {
        if ((flags & 1) != 0) {
            if (timeStyle < 0 || timeStyle > 3) {
                throw new IllegalArgumentException("Illegal time style " + timeStyle);
            }
        } else {
            timeStyle = -1;
        }
        if ((flags & 2) != 0) {
            if (dateStyle < 0 || dateStyle > 3) {
                throw new IllegalArgumentException("Illegal date style " + dateStyle);
            }
        } else {
            dateStyle = -1;
        }
        StringBuilder builder = new StringBuilder();
        if (dateStyle != -1) {
            builder.append(DateFormat.getDatePattern(dateStyle));
            if (timeStyle != -1) {
                builder.append(" ");
            }
        }
        if (timeStyle != -1) {
            builder.append(DateFormat.getTimePattern(timeStyle));
        }
        return DateFormat.getInstance(builder.toString());
    }

    private static DateFormat getInstance(String string) {
        DateFormat dateFormat = FormaterPoll.get(string);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(string);
            FormaterPoll.put(string, dateFormat);
        }
        return dateFormat;
    }

    private static String getDatePattern(int dateStyle) {
        String pattern;
        switch (dateStyle) {
            case 3: {
                pattern = "MM/dd/yy";
                break;
            }
            case 2: {
                pattern = "MMM dd, y";
                break;
            }
            case 1: {
                pattern = "MMMM dd, y";
                break;
            }
            case 0: {
                pattern = "EEEE, MMMM dd, y";
                break;
            }
            default: {
                pattern = "";
            }
        }
        return pattern;
    }

    private static String getTimePattern(int timeStyle) {
        String pattern;
        switch (timeStyle) {
            case 2: 
            case 3: {
                pattern = "h:mma";
                break;
            }
            case 0: 
            case 1: {
                pattern = "h:mm:ssa";
                break;
            }
            default: {
                pattern = "";
            }
        }
        return pattern;
    }
}

