/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth;

import ej.bluetooth.BluetoothAddress;
import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.listeners.ConnectionListener;
import ej.bluetooth.listeners.LocalServiceListener;
import ej.bluetooth.listeners.RemoteServiceListener;
import ej.bon.ByteArray;
import ej.library.iot.rcommand.bluetooth.BluetoothController;

public class EventSerializer
implements ConnectionListener,
RemoteServiceListener,
LocalServiceListener {
    private static final byte ADDRESS_TYPE_PUBLIC = 0;
    private static final byte ADDRESS_TYPE_PRIVATE = 1;
    private static final byte ATTRIBUTE_TYPE_CHARACTERISTIC = 0;
    private static final byte ATTRIBUTE_TYPE_DESCRIPTOR = 1;
    private static final int SERVICE_HEADER_SIZE = 22;
    private static final int ATTRIBUTE_SIZE = 22;
    private final BluetoothController controller;

    public EventSerializer(BluetoothController controller) {
        this.controller = controller;
    }

    public void onScanResult(BluetoothAddress address, byte[] advertisementData, int rssi) {
        byte[] event = new byte[10 + advertisementData.length];
        event[0] = 1;
        event[1] = address.isPublic() ? (byte)0 : 1;
        address.getBytes(event, 2);
        event[8] = (byte)rssi;
        event[9] = (byte)advertisementData.length;
        System.arraycopy(advertisementData, 0, event, 10, advertisementData.length);
        this.controller.sendEvent(event);
    }

    public void onScanCompleted() {
        byte[] event = new byte[]{2};
        this.controller.sendEvent(event);
    }

    public void onAdvertisementCompleted() {
        byte[] event = new byte[]{3};
        this.controller.sendEvent(event);
    }

    public void onConnectFailed(BluetoothAddress address) {
        byte[] event = new byte[8];
        event[0] = 4;
        event[1] = address.isPublic() ? (byte)0 : 1;
        address.getBytes(event, 2);
        this.controller.sendEvent(event);
    }

    public void onConnected(BluetoothConnection connection) {
        BluetoothAddress address = connection.getAddress();
        short connHandle = this.controller.onConnected(connection);
        byte[] event = new byte[10];
        event[0] = 5;
        event[1] = address.isPublic() ? (byte)0 : 1;
        address.getBytes(event, 2);
        ByteArray.writeShort((byte[])event, (int)8, (int)connHandle);
        this.controller.sendEvent(event);
    }

    public void onDisconnected(BluetoothConnection connection) {
        Short connHandle = this.controller.onDisconnected(connection);
        if (connHandle != null) {
            byte[] event = new byte[4];
            event[0] = 6;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            this.controller.sendEvent(event);
        }
    }

    public void onPairRequest(BluetoothConnection connection) {
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null) {
            byte[] event = new byte[4];
            event[0] = 7;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            this.controller.sendEvent(event);
        }
    }

    public void onPairCompleted(BluetoothConnection connection, boolean success) {
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null) {
            byte[] event = new byte[4];
            event[0] = 8;
            event[1] = (byte)(success ? 1 : 0);
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            this.controller.sendEvent(event);
        }
    }

    public void onPasskeyRequest(BluetoothConnection connection) {
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null) {
            byte[] event = new byte[4];
            event[0] = 9;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            this.controller.sendEvent(event);
        }
    }

    public void onPasskeyGenerated(BluetoothConnection connection, int passkey) {
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null) {
            byte[] event = new byte[8];
            event[0] = 10;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            ByteArray.writeInt((byte[])event, (int)4, (int)passkey);
            this.controller.sendEvent(event);
        }
    }

    public void onDiscoveryResult(BluetoothConnection connection, BluetoothService service) {
        Short serviceHandle;
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null && (serviceHandle = this.controller.onServiceDiscovered(connection, service)) != null) {
            int numAttributes = EventSerializer.countAttributes(service);
            byte[] event = new byte[22 + numAttributes * 22];
            event[0] = 11;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            event[1] = (byte)numAttributes;
            ByteArray.writeShort((byte[])event, (int)4, (int)serviceHandle.shortValue());
            service.getUuid().getBytes(event, 6);
            int attrOffset = 22;
            int numCharacteristics = service.getNumCharacteristics();
            int c = 0;
            while (c < numCharacteristics) {
                BluetoothCharacteristic characteristic = service.getCharacteristic(c);
                Short characteristicHandle = this.controller.getRemoteAttributeHandle(connection, (BluetoothAttribute)characteristic);
                if (characteristicHandle == null) {
                    return;
                }
                event[attrOffset] = 0;
                characteristic.getUuid().getBytes(event, attrOffset + 2);
                ByteArray.writeShort((byte[])event, (int)(attrOffset + 18), (int)characteristicHandle.shortValue());
                event[attrOffset + 20] = characteristic.getProperties();
                attrOffset += 22;
                int numDescriptors = characteristic.getNumDescriptors();
                int d = 0;
                while (d < numDescriptors) {
                    BluetoothDescriptor descriptor = characteristic.getDescriptor(d);
                    Short descriptorHandle = this.controller.getRemoteAttributeHandle(connection, (BluetoothAttribute)descriptor);
                    if (descriptorHandle == null) {
                        return;
                    }
                    event[attrOffset] = 1;
                    descriptor.getUuid().getBytes(event, attrOffset + 2);
                    ByteArray.writeShort((byte[])event, (int)(attrOffset + 18), (int)descriptorHandle.shortValue());
                    attrOffset += 22;
                    ++d;
                }
                ++c;
            }
            this.controller.sendEvent(event);
        }
    }

    public void onDiscoveryCompleted(BluetoothConnection connection) {
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null) {
            byte[] event = new byte[4];
            event[0] = 12;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            this.controller.sendEvent(event);
        }
    }

    public void onReadCompleted(BluetoothConnection connection, BluetoothAttribute attribute, byte status, byte[] value) {
        Short attrHandle;
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null && (attrHandle = this.controller.getRemoteAttributeHandle(connection, attribute)) != null) {
            byte[] event = new byte[8 + value.length];
            event[0] = 13;
            event[1] = status;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)4, (int)attrHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)6, (int)value.length);
            System.arraycopy(value, 0, event, 8, value.length);
            this.controller.sendEvent(event);
        }
    }

    public void onWriteCompleted(BluetoothConnection connection, BluetoothAttribute attribute, byte status) {
        Short attrHandle;
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null && (attrHandle = this.controller.getRemoteAttributeHandle(connection, attribute)) != null) {
            byte[] event = new byte[6];
            event[0] = 14;
            event[1] = status;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)4, (int)attrHandle.shortValue());
            this.controller.sendEvent(event);
        }
    }

    public void onNotificationReceived(BluetoothConnection connection, BluetoothCharacteristic characteristic, byte[] value) {
        Short attrHandle;
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null && (attrHandle = this.controller.getRemoteAttributeHandle(connection, (BluetoothAttribute)characteristic)) != null) {
            byte[] event = new byte[8 + value.length];
            event[0] = 15;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)4, (int)attrHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)6, (int)value.length);
            System.arraycopy(value, 0, event, 8, value.length);
            this.controller.sendEvent(event);
        }
    }

    public void onReadRequest(BluetoothConnection connection, BluetoothAttribute attribute) {
        Short attrHandle;
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null && (attrHandle = this.controller.getLocalAttributeHandle(attribute)) != null) {
            byte[] event = new byte[6];
            event[0] = 16;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)4, (int)attrHandle.shortValue());
            this.controller.sendEvent(event);
        }
    }

    public void onWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value) {
        Short attrHandle;
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null && (attrHandle = this.controller.getLocalAttributeHandle(attribute)) != null) {
            byte[] event = new byte[8 + value.length];
            event[0] = 17;
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)4, (int)attrHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)6, (int)value.length);
            System.arraycopy(value, 0, event, 8, value.length);
            this.controller.sendEvent(event);
        }
    }

    public void onNotificationSent(BluetoothConnection connection, BluetoothCharacteristic characteristic, boolean success) {
        Short attrHandle;
        Short connHandle = this.controller.getConnHandle(connection);
        if (connHandle != null && (attrHandle = this.controller.getLocalAttributeHandle((BluetoothAttribute)characteristic)) != null) {
            byte[] event = new byte[6];
            event[0] = 18;
            event[1] = (byte)(success ? 1 : 0);
            ByteArray.writeShort((byte[])event, (int)2, (int)connHandle.shortValue());
            ByteArray.writeShort((byte[])event, (int)4, (int)attrHandle.shortValue());
            this.controller.sendEvent(event);
        }
    }

    private static int countAttributes(BluetoothService service) {
        int numCharacteristics = service.getNumCharacteristics();
        int numDescriptors = 0;
        int c = 0;
        while (c < numCharacteristics) {
            numDescriptors += service.getCharacteristic(c).getNumDescriptors();
            ++c;
        }
        return numCharacteristics + numDescriptors;
    }
}

