/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import ej.bon.Util;
import ej.util.message.basic.BasicMessageLogger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SntpClient {
    private static final String LOG_CATEGORY = "SntpClient";
    private static final int LOG_ID_RESPONSE_RECEIVED = 0;
    private static final int LOG_ID_UNKNOWN_HOST = 1;
    private static final int LOG_ID_REQUEST_TIME_FAILED = 2;
    private static final int LOG_ID_REQUEST_EXCEPTION = 3;
    private static final int REFERENCE_TIME_OFFSET = 16;
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_MODE_SERVER = 4;
    private static final int NTP_MODE_BROADCAST = 5;
    private static final int NTP_VERSION = 3;
    private static final int NTP_LEAP_NOSYNC = 3;
    private static final int NTP_STRATUM_DEATH = 0;
    private static final int NTP_STRATUM_MAX = 15;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private long mNtpTime;
    private long mNtpTimeReference;
    private long mRoundTripTime;

    public boolean requestTime(String host, int timeout) {
        return this.requestTime(host, 123, timeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean requestTime(String host, int port, int timeout) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            int i = 0;
            while (i < addresses.length) {
                InetAddress addr = addresses[i];
                if (addr != null && this.requestTime(addr, port, timeout)) {
                    return true;
                }
                ++i;
            }
        }
        catch (UnknownHostException unknownHostException) {
            BasicMessageLogger.INSTANCE.log('W', LOG_CATEGORY, 1, new Object[]{host});
        }
        BasicMessageLogger.INSTANCE.log('F', LOG_CATEGORY, 2);
        return false;
    }

    boolean requestTime(InetAddress address, int port, int timeout) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DatagramSocket socket = new DatagramSocket();){
                socket.setSoTimeout(timeout);
                byte[] buffer = new byte[48];
                DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, port);
                buffer[0] = 27;
                long requestTime = System.currentTimeMillis();
                long requestTicks = Util.platformTimeMillis();
                this.writeTimeStamp(buffer, 40, requestTime);
                socket.send(request);
                DatagramPacket response = new DatagramPacket(buffer, buffer.length);
                socket.receive(response);
                long responseTicks = Util.platformTimeMillis();
                long responseTime = requestTime + (responseTicks - requestTicks);
                byte leap = (byte)(buffer[0] >> 6 & 3);
                byte mode = (byte)(buffer[0] & 7);
                int stratum = buffer[1] & 0xFF;
                long originateTime = this.readTimeStamp(buffer, 24);
                long receiveTime = this.readTimeStamp(buffer, 32);
                long transmitTime = this.readTimeStamp(buffer, 40);
                long referenceTime = this.readTimeStamp(buffer, 16);
                SntpClient.checkValidServerReply(leap, mode, stratum, transmitTime, referenceTime);
                long roundTripTime = responseTicks - requestTicks - (transmitTime - receiveTime);
                long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
                BasicMessageLogger.INSTANCE.log('F', LOG_CATEGORY, 0, new Object[]{roundTripTime, clockOffset});
                this.mNtpTime = responseTime + clockOffset;
                this.mNtpTimeReference = responseTicks;
                this.mRoundTripTime = roundTripTime;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            BasicMessageLogger.INSTANCE.log('F', LOG_CATEGORY, 3, (Throwable)e);
            return false;
        }
        return true;
    }

    public long getNtpTime() {
        return this.mNtpTime;
    }

    public long getNtpTimeReference() {
        return this.mNtpTimeReference;
    }

    public long getRoundTripTime() {
        return this.mRoundTripTime;
    }

    private static void checkValidServerReply(byte leap, byte mode, int stratum, long transmitTime, long referenceTime) throws InvalidServerReplyException {
        if (leap == 3) {
            throw new InvalidServerReplyException("unsynchronized server");
        }
        if (mode != 4 && mode != 5) {
            throw new InvalidServerReplyException("untrusted mode: " + mode);
        }
        if (stratum == 0 || stratum > 15) {
            throw new InvalidServerReplyException("untrusted stratum: " + stratum);
        }
        if (transmitTime == 0L) {
            throw new InvalidServerReplyException("zero transmitTime");
        }
        if (referenceTime == 0L) {
            throw new InvalidServerReplyException("zero reference timestamp");
        }
    }

    private long read32(byte[] buffer, int offset) {
        int b0 = buffer[offset];
        int b1 = buffer[offset + 1];
        int b2 = buffer[offset + 2];
        int b3 = buffer[offset + 3];
        int i0 = (b0 & 0x80) == 128 ? (b0 & 0x7F) + 128 : b0;
        int i1 = (b1 & 0x80) == 128 ? (b1 & 0x7F) + 128 : b1;
        int i2 = (b2 & 0x80) == 128 ? (b2 & 0x7F) + 128 : b2;
        int i3 = (b3 & 0x80) == 128 ? (b3 & 0x7F) + 128 : b3;
        return ((long)i0 << 24) + ((long)i1 << 16) + ((long)i2 << 8) + (long)i3;
    }

    private long readTimeStamp(byte[] buffer, int offset) {
        long seconds = this.read32(buffer, offset);
        long fraction = this.read32(buffer, offset + 4);
        if (seconds == 0L && fraction == 0L) {
            return 0L;
        }
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }

    private void writeTimeStamp(byte[] buffer, int offset, long time) {
        if (time == 0L) {
            int i = 0;
            while (i < 8) {
                buffer[offset + i] = 0;
                ++i;
            }
            return;
        }
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)(seconds >> 0);
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction >> 24);
        buffer[offset++] = (byte)(fraction >> 16);
        buffer[offset++] = (byte)(fraction >> 8);
        buffer[offset++] = (byte)(Math.random() * 255.0);
    }

    private static class InvalidServerReplyException
    extends Exception {
        public InvalidServerReplyException(String message) {
            super(message);
        }
    }
}

