/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util;

import com.microej.kf.util.message.KfUtilMessage;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.kf.Proxy;
import org.eclipse.core.runtime.IProgressMonitor;

public class IProgressMonitorProxy
extends Proxy<IProgressMonitor>
implements IProgressMonitor {
    private final Proxy<IProgressMonitor> proxy;

    public IProgressMonitorProxy(Proxy<IProgressMonitor> proxy) {
        this.proxy = proxy;
    }

    public void beginTask(String name, int totalWork) {
        Kernel.enter();
        IProgressMonitor target = (IProgressMonitor)this.proxy.getReference();
        if (target == null) {
            return;
        }
        Module owner = Kernel.getOwner((Object)target);
        try {
            target.beginTask((String)Kernel.clone((Object)name, (Module)owner), totalWork);
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 1, t);
        }
    }

    public void done() {
        Kernel.enter();
        try {
            ((IProgressMonitor)this.proxy.getReference()).done();
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 1, t);
        }
    }

    public void internalWorked(double work) {
        Kernel.enter();
        try {
            ((IProgressMonitor)this.proxy.getReference()).internalWorked(work);
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 1, t);
        }
    }

    public boolean isCanceled() {
        Kernel.enter();
        try {
            return ((IProgressMonitor)this.proxy.getReference()).isCanceled();
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 1, t);
            return false;
        }
    }

    public void setCanceled(boolean value) {
        Kernel.enter();
        try {
            ((IProgressMonitor)this.proxy.getReference()).setCanceled(value);
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 1, t);
        }
    }

    public void setTaskName(String name) {
        Kernel.enter();
        IProgressMonitor target = (IProgressMonitor)this.proxy.getReference();
        if (target == null) {
            return;
        }
        Module owner = Kernel.getOwner((Object)target);
        try {
            target.setTaskName((String)Kernel.clone((Object)name, (Module)owner));
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 1, t);
        }
    }

    public void subTask(String name) {
        Kernel.enter();
        IProgressMonitor target = (IProgressMonitor)this.proxy.getReference();
        if (target == null) {
            return;
        }
        Module owner = Kernel.getOwner((Object)target);
        try {
            target.subTask((String)Kernel.clone((Object)name, (Module)owner));
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 1, t);
        }
    }

    public void worked(int work) {
        Kernel.enter();
        try {
            ((IProgressMonitor)this.proxy.getReference()).worked(work);
        }
        catch (Throwable t) {
            KfUtilMessage.LOGGER.log('I', "KfUtil", 1, t);
        }
    }
}

