/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.comm;

import ej.ecom.io.CommConnection;
import ej.ecom.io.Connector;
import ej.rcommand.RemoteCommandManager;
import ej.rcommand.RemoteConnection;
import ej.rcommand.connectivity.ConnectivityListener;
import ej.rcommand.connectivity.ConnectivityManager;
import ej.rcommand.impl.StreamRemoteConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteCommandCommPopulator
implements ConnectivityManager {
    private final String connectionString;
    private final Logger logger;
    private CommConnection commConnection;
    private StreamRemoteConnection streamRemoteConnection;
    private RemoteCommandManager commandManager;
    private final List<ConnectivityListener> listeners;

    public RemoteCommandCommPopulator(String connectionString) {
        this.connectionString = connectionString;
        this.logger = Logger.getLogger(RemoteCommandCommPopulator.class.getSimpleName());
        this.listeners = new ArrayList<ConnectivityListener>();
    }

    public synchronized void start(RemoteCommandManager commandManager) throws IOException {
        this.commandManager = commandManager;
        this.commConnection = (CommConnection)Connector.open((String)this.connectionString);
        this.streamRemoteConnection = new StreamRemoteConnection(this.commConnection.openInputStream(), this.commConnection.openOutputStream());
        commandManager.startReading((RemoteConnection)this.streamRemoteConnection, this.connectionString);
        this.notifyConnectivityListener(true);
    }

    public synchronized void stop() {
        if (this.commConnection != null) {
            this.notifyConnectivityListener(true);
            try {
                this.commandManager.stopReading((RemoteConnection)this.streamRemoteConnection);
                this.commConnection.close();
                this.commConnection = null;
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Exception thrown when closing the comm connection.", e);
            }
        }
    }

    public synchronized int getAvailable() {
        return this.commConnection == null ? 0 : 1;
    }

    public String getConnectionInfo() {
        if (this.commConnection != null) {
            return this.connectionString;
        }
        return null;
    }

    private synchronized void notifyConnectivityListener(boolean connect) {
        if (connect) {
            for (ConnectivityListener listener : this.listeners) {
                listener.onConnect();
            }
        } else {
            for (ConnectivityListener listener : this.listeners) {
                listener.onDisconnect();
            }
        }
    }

    public synchronized void addConnectivityListener(ConnectivityListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeConnectivityListener(ConnectivityListener listener) {
        this.listeners.remove(listener);
    }
}

