/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget;

import ej.fp.Widget;
import ej.fp.util.ThirdEventThread;
import ej.fp.widget.Button;
import ej.microui.event.EventButton;

@Widget.WidgetDescription(attributes={@Widget.WidgetAttribute(name="label"), @Widget.WidgetAttribute(name="x"), @Widget.WidgetAttribute(name="y"), @Widget.WidgetAttribute(name="skin"), @Widget.WidgetAttribute(name="pushedSkin"), @Widget.WidgetAttribute(name="repeatPeriod", isOptional=true), @Widget.WidgetAttribute(name="filter", isOptional=true), @Widget.WidgetAttribute(name="listenerClass", isOptional=true)})
public class RepeatButton
extends Button
implements ThirdEventThread.ThirdEventWidget {
    private final ThirdEventThread repeatThread = new ThirdEventThread(this, true);
    private int repeatPeriod = 200;

    public void setRepeatPeriod(int period) {
        if (this.repeatPeriod <= 0) {
            throw new IllegalArgumentException("Repeat period cannot be negative.");
        }
        this.repeatPeriod = period;
    }

    @Override
    public void setListenerClass(String listenerClassName) {
        this.setListenerClass(RepeatButtonListener.class, listenerClassName);
    }

    @Override
    public void start() {
        super.start();
        this.repeatThread.start();
    }

    @Override
    public void dispose() {
        this.repeatThread.dispose();
        super.dispose();
    }

    @Override
    protected Object newDefaultListener() {
        return new RepeatButtonListenerToButtonEvents();
    }

    @Override
    public void sendThirdEvent() {
        ((RepeatButtonListener)this.getListener()).repeat(this);
    }

    @Override
    public int getSleepPeriod() {
        return this.repeatPeriod;
    }

    @Override
    protected void press() {
        ThirdEventThread repeatThread = this.repeatThread;
        if (!repeatThread.isSendingThirdEvent()) {
            super.press();
            repeatThread.wakeup();
        }
    }

    @Override
    protected void release() {
        this.repeatThread.goToSleep();
        super.release();
    }

    public static interface RepeatButtonListener
    extends Button.ButtonListener {
        public void repeat(RepeatButton var1);
    }

    public static class RepeatButtonListenerToButtonEvents
    extends Button.ButtonListenerToButtonEvents
    implements RepeatButtonListener {
        @Override
        public void repeat(RepeatButton widget) {
            EventButton.sendRepeatedEvent((String)this.getMicroUIGeneratorTag(), (int)widget.getID());
        }
    }
}

