/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothAddress;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;
import java.io.IOException;

public class ConnectEndpoint
implements Endpoint {
    private static final byte ADDRESS_TYPE_PUBLIC = 0;
    @Nullable
    private byte[] deviceAddress;

    public String getName() {
        return "bluetooth_connect";
    }

    public void readRequestBody(CommandReader reader) throws IOException {
        this.deviceAddress = reader.readByteArray();
    }

    public void writeResponseBody(CommandSender sender) throws IOException {
        byte[] deviceAddress = this.deviceAddress;
        assert (deviceAddress != null);
        boolean isPublic = deviceAddress[0] == 0;
        BluetoothAddress address = new BluetoothAddress(deviceAddress, 1, isPublic);
        if (BluetoothAdapter.getAdapter().connect(address)) {
            sender.sendInt(0);
        } else {
            sender.sendInt(1);
        }
    }
}

