/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.auth.session;

import ej.hoka.auth.SessionAuthenticator;
import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.requesthandler.RequestHandlerComposite;
import java.util.Map;

public class AuthenticatedRequestHandler
extends RequestHandlerComposite {
    private static final String SLASH = "/";
    private final SessionAuthenticator authenticator;
    private final String root;

    public AuthenticatedRequestHandler(SessionAuthenticator authenticator, String root) {
        this.authenticator = authenticator;
        if (root.endsWith(SLASH)) {
            root = root.substring(0, root.length() - 1);
        }
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    @Override
    public HTTPResponse process(HTTPRequest request, Map<String, String> attributes) {
        if (!this.match(request)) {
            return null;
        }
        String sessionID = this.getSessionID(request, attributes);
        String username = this.authenticator.authenticate(sessionID);
        if (username == null) {
            return this.onFailedAuthentication(request, attributes);
        }
        return this.onSuccessfulAuthentication(request, attributes, username, sessionID);
    }

    protected boolean match(HTTPRequest request) {
        return request.getURI().startsWith(this.root);
    }

    protected String getSessionID(HTTPRequest request, Map<String, String> attributes) {
        return request.getCookie("token");
    }

    protected HTTPResponse onSuccessfulAuthentication(HTTPRequest request, Map<String, String> attributes, String username, String sessionID) {
        attributes.put("username", username);
        HTTPResponse response = super.process(request, attributes);
        if (response == null) {
            return null;
        }
        return response;
    }

    protected HTTPResponse onFailedAuthentication(HTTPRequest request, Map<String, String> attributes) {
        return HTTPResponse.createError("401 Unauthorized", "");
    }
}

