/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Arrays;
import sun.misc.FloatingDecimal;

public class FormattedFloatingDecimal {
    private char[] mantissa;

    public static FormattedFloatingDecimal valueOf(double d, int precision, Object arg) {
        FloatingDecimal.BinaryToASCIIConverter fdConverter = FloatingDecimal.getBinaryToASCIIConverter(d, arg);
        return new FormattedFloatingDecimal(precision, fdConverter);
    }

    private FormattedFloatingDecimal(int precision, FloatingDecimal.BinaryToASCIIConverter fdConverter) {
        if (fdConverter.isExceptional()) {
            this.mantissa = fdConverter.toJavaFormatString().toCharArray();
            return;
        }
        char[] digits = new char[20];
        int nDigits = fdConverter.getDigits(digits);
        int decExp = fdConverter.getDecimalExponent();
        boolean isNegative = fdConverter.isNegative();
        int exp = FormattedFloatingDecimal.applyPrecision(decExp, digits, nDigits, decExp + precision);
        this.mantissa = this.fillDecimal(precision, digits, nDigits, exp, isNegative);
    }

    public char[] getMantissa() {
        return this.mantissa;
    }

    private static int applyPrecision(int decExp, char[] digits, int nDigits, int prec) {
        if (prec >= nDigits || prec < 0) {
            return decExp;
        }
        if (prec == 0) {
            if (digits[0] >= '5') {
                digits[0] = 49;
                Arrays.fill(digits, 1, nDigits, '0');
                return decExp + 1;
            }
            Arrays.fill(digits, 0, nDigits, '0');
            return decExp;
        }
        char q = digits[prec];
        if (q >= '5') {
            int i = prec;
            if ((q = digits[--i]) == '9') {
                while (q == '9' && i > 0) {
                    q = digits[--i];
                }
                if (q == '9') {
                    digits[0] = 49;
                    Arrays.fill(digits, 1, nDigits, '0');
                    return decExp + 1;
                }
            }
            digits[i] = (char)(q + '\u0001');
            Arrays.fill(digits, i + 1, nDigits, '0');
        } else {
            Arrays.fill(digits, prec, nDigits, '0');
        }
        return decExp;
    }

    private static char[] create(boolean isNegative, int size) {
        if (isNegative) {
            char[] r = new char[size + 1];
            r[0] = 45;
            return r;
        }
        return new char[size];
    }

    private char[] fillDecimal(int precision, char[] digits, int nDigits, int exp, boolean isNegative) {
        char[] mantissa;
        int startIndex;
        int n = startIndex = isNegative ? 1 : 0;
        if (exp > 0) {
            if (nDigits < exp) {
                mantissa = FormattedFloatingDecimal.create(isNegative, exp);
                System.arraycopy(digits, 0, mantissa, startIndex, nDigits);
                Arrays.fill(mantissa, startIndex + nDigits, startIndex + exp, '0');
            } else {
                int t = Math.min(nDigits - exp, precision);
                mantissa = FormattedFloatingDecimal.create(isNegative, exp + (t > 0 ? t + 1 : 0));
                System.arraycopy(digits, 0, mantissa, startIndex, exp);
                if (t > 0) {
                    mantissa[startIndex + exp] = 46;
                    System.arraycopy(digits, exp, mantissa, startIndex + exp + 1, t);
                }
            }
        } else {
            int zeros = Math.max(0, Math.min(-exp, precision));
            int t = Math.max(0, Math.min(nDigits, precision + exp));
            if (zeros > 0) {
                mantissa = FormattedFloatingDecimal.create(isNegative, zeros + 2 + t);
                mantissa[startIndex] = 48;
                mantissa[startIndex + 1] = 46;
                Arrays.fill(mantissa, startIndex + 2, startIndex + 2 + zeros, '0');
                if (t > 0) {
                    System.arraycopy(digits, 0, mantissa, startIndex + 2 + zeros, t);
                }
            } else if (t > 0) {
                mantissa = FormattedFloatingDecimal.create(isNegative, zeros + 2 + t);
                mantissa[startIndex] = 48;
                mantissa[startIndex + 1] = 46;
                System.arraycopy(digits, 0, mantissa, startIndex + 2, t);
            } else {
                mantissa = FormattedFloatingDecimal.create(isNegative, 1);
                mantissa[startIndex] = 48;
            }
        }
        return mantissa;
    }
}

