/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.event;

import ej.fp.FrontPanel;
import ej.microui.event.LLUIInput;

public class EventGeneric {
    private EventGeneric() {
    }

    public static void sendEvent(String eventGenerator, int event) {
        int[] events = new int[2];
        events[1] = event;
        EventGeneric.sendUserEvents(eventGenerator, events);
    }

    public static void sendEvents(String eventGenerator, int[] eventsArray) {
        int length = Math.min(eventsArray.length, 256);
        int[] events = new int[length + 1];
        System.arraycopy(eventsArray, 0, events, 1, length);
        EventGeneric.sendUserEvents(eventGenerator, events);
    }

    private static void sendUserEvents(String eventGenerator, int[] events) {
        int eventsLength = events.length;
        try {
            events[0] = LLUIInput.buildEvent(eventGenerator, eventsLength - 1);
            LLUIInput.sendEvents(events);
        }
        catch (IllegalArgumentException e) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            buf.append(EventGeneric.class.getName());
            buf.append("] send events : {");
            int i = 0;
            while (++i < eventsLength) {
                buf.append("0x");
                buf.append(Integer.toHexString(events[i]));
                if (i == eventsLength - 1) continue;
                buf.append(", ");
            }
            buf.append("} (");
            buf.append(eventGenerator);
            buf.append(")");
            FrontPanel.out.println(buf.toString());
        }
    }
}

