/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.monitoring;

import com.microej.kf.util.monitoring.MonitoringData;
import com.microej.kf.util.monitoring.ResourceMonitoringService;
import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import ej.bon.Timer;
import ej.bon.TimerTask;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import ej.kf.Module;

public class ResourceMonitoringServiceImpl
implements ResourceMonitoringService,
FeatureStateListener {
    private static final int NO_QUOTA = -1;
    private static final int CALIBRATION_QUOTA = Integer.getInteger("monitoring.check.cpu.calibration", 100000);
    private static final float ONE_SECOND = 1000.0f;
    private static final float MAX_USAGE = 1.0f;
    private final Timer timer;
    private final long intervalMillis;
    private final boolean runGcBeforeCollecting;
    private final MonitoringData monitoringData;
    @Nullable
    private TimerTask monitoringTask;
    private boolean running;

    public ResourceMonitoringServiceImpl(Timer timer, long intervalMillis, boolean runGcBeforeCollecting) {
        this.timer = timer;
        this.intervalMillis = intervalMillis;
        this.runGcBeforeCollecting = runGcBeforeCollecting;
        Kernel.addFeatureStateListener((FeatureStateListener)this);
        this.monitoringData = new MonitoringData(runGcBeforeCollecting);
        this.monitoringTask = null;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.enableModuleMonitoring((Module)Kernel.getInstance());
        Feature[] featureArray = Kernel.getAllLoadedFeatures();
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature module = featureArray[n2];
            if (Feature.State.STARTED.equals((Object)module.getState())) {
                this.enableModuleMonitoring((Module)module);
            }
            ++n2;
        }
        this.monitoringTask = new MonitoringTask(this.monitoringData, this.runGcBeforeCollecting);
        this.timer.scheduleAtFixedRate(this.monitoringTask, 0L, this.intervalMillis);
        this.running = true;
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.monitoringTask.cancel();
        this.disableModuleMonitoring((Module)Kernel.getInstance());
        Feature[] featureArray = Kernel.getAllLoadedFeatures();
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature module = featureArray[n2];
            if (Feature.State.STARTED.equals((Object)module.getState())) {
                this.disableModuleMonitoring((Module)module);
            }
            ++n2;
        }
        this.running = false;
    }

    public void stateChanged(Feature app, @Nullable Feature.State state) {
        Feature.State currentState = app.getState();
        if (Feature.State.STARTED.equals((Object)currentState)) {
            this.enableModuleMonitoring((Module)app);
        } else if (Feature.State.STOPPED.equals((Object)currentState)) {
            this.disableModuleMonitoring((Module)app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackedMap<String, Float> getUsedCpuPercentPerModule() {
        PackedMap result = new PackedMap();
        MonitoringData monitoringData = this.monitoringData;
        synchronized (monitoringData) {
            long totalExecutionCounter = 0L;
            for (MonitoringData.ExecutionCounter execCounter : this.monitoringData.getExecutionCounterPerModuleMap().values()) {
                totalExecutionCounter += execCounter.getCurrent() - execCounter.getLast();
            }
            float totalShare = 0.0f;
            for (Module module : this.monitoringData.getExecutionCounterPerModuleMap().keySet()) {
                MonitoringData.ExecutionCounter execCounter = (MonitoringData.ExecutionCounter)this.monitoringData.getExecutionCounterPerModuleMap().get((Object)module);
                if (totalExecutionCounter > 0L) {
                    long delta = execCounter.getCurrent() - execCounter.getLast();
                    float usageShare = (float)delta / (float)this.intervalMillis * 1000.0f / (float)CALIBRATION_QUOTA;
                    totalShare += usageShare;
                    result.put((Object)module.getName(), (Object)Float.valueOf(usageShare));
                    continue;
                }
                result.put((Object)module.getName(), (Object)Float.valueOf(0.0f));
            }
            if (totalShare > 1.0f) {
                float factor = 1.0f / totalShare;
                for (String module : result.keySet()) {
                    float value = ((Float)result.get((Object)module)).floatValue();
                    result.put((Object)module, (Object)Float.valueOf(value * factor));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackedMap<String, Long> getUsedMemoryPerModule() {
        PackedMap result = new PackedMap();
        MonitoringData monitoringData = this.monitoringData;
        synchronized (monitoringData) {
            for (Module module : this.monitoringData.getRamUsagePerModuleMap().keySet()) {
                result.put((Object)module.getName(), (Object)((Long)this.monitoringData.getRamUsagePerModuleMap().get((Object)module)));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackedMap<String, Float> getUsedMemoryPercentPerModule() {
        PackedMap result = new PackedMap();
        MonitoringData monitoringData = this.monitoringData;
        synchronized (monitoringData) {
            for (Module module : this.monitoringData.getRamUsagePerModuleMap().keySet()) {
                long value = (Long)this.monitoringData.getRamUsagePerModuleMap().get((Object)module);
                result.put((Object)module.getName(), (Object)Float.valueOf((float)value / (float)this.monitoringData.getTotalMemory()));
            }
        }
        return result;
    }

    @Override
    public long getFreeMemory() {
        return this.monitoringData.getFreeMemory();
    }

    @Override
    public long getMaxMemory() {
        return this.monitoringData.getMaxMemory();
    }

    @Override
    public long getTotalMemory() {
        return this.monitoringData.getTotalMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableModuleMonitoring(Module module) {
        boolean noQuota;
        int previousQuota = module.getExecutionQuota();
        boolean bl = noQuota = previousQuota == -1;
        if (noQuota) {
            module.setExecutionQuota(-1);
        }
        MonitoringData monitoringData = this.monitoringData;
        synchronized (monitoringData) {
            this.monitoringData.getOriginalQuotaPerModuleMap().put((Object)module, (Object)previousQuota);
            this.monitoringData.getExecutionCounterPerModuleMap().put((Object)module, (Object)new MonitoringData.ExecutionCounter(0L, 0L));
            this.monitoringData.getRamUsagePerModuleMap().put((Object)module, (Object)0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableModuleMonitoring(Module module) {
        MonitoringData monitoringData = this.monitoringData;
        synchronized (monitoringData) {
            this.monitoringData.getExecutionCounterPerModuleMap().remove((Object)module);
            this.monitoringData.getRamUsagePerModuleMap().remove((Object)module);
            Integer originalQuota = (Integer)this.monitoringData.getOriginalQuotaPerModuleMap().remove((Object)module);
            if (originalQuota != null) {
                module.setExecutionQuota(originalQuota.intValue());
            }
        }
    }

    public static final class MonitoringTask
    extends TimerTask {
        private final MonitoringData monitoringData;
        private final boolean runGcBeforeCollecting;

        public MonitoringTask(MonitoringData monitoringData, boolean runGcBeforeCollecting) {
            this.monitoringData = monitoringData;
            this.runGcBeforeCollecting = runGcBeforeCollecting;
        }

        public void run() {
            if (this.runGcBeforeCollecting) {
                Runtime.getRuntime().gc();
            }
            Feature[] featureArray = Kernel.getAllLoadedFeatures();
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature app = featureArray[n2];
                if (app.getState() == Feature.State.STARTED) {
                    this.computeModuleCpuUsage((Module)app);
                    this.computeModuleMemoryUsage((Module)app);
                }
                ++n2;
            }
            this.computeModuleCpuUsage((Module)Kernel.getInstance());
            this.computeModuleMemoryUsage((Module)Kernel.getInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeModuleCpuUsage(Module module) {
            MonitoringData monitoringData = this.monitoringData;
            synchronized (monitoringData) {
                MonitoringData.ExecutionCounter exec = (MonitoringData.ExecutionCounter)this.monitoringData.getExecutionCounterPerModuleMap().get((Object)module);
                if (exec != null) {
                    long newExecutionCounter = module.getExecutionCounter();
                    exec.setLast(newExecutionCounter < exec.getCurrent() ? 0L : exec.getCurrent());
                    exec.setCurrent(newExecutionCounter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeModuleMemoryUsage(Module module) {
            MonitoringData monitoringData = this.monitoringData;
            synchronized (monitoringData) {
                this.monitoringData.getRamUsagePerModuleMap().put((Object)module, (Object)module.getAllocatedMemory());
            }
        }
    }
}

