/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.control.net;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class Subnet {
    private final InetAddress networkAddress;
    private final int maskBits;

    public Subnet(InetAddress networkAddress, int mask) {
        this.networkAddress = networkAddress;
        this.maskBits = mask;
    }

    public InetAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public int getMask() {
        return this.maskBits;
    }

    public boolean matches(InetAddress ipAddress) {
        InetAddress networkAddress = this.getNetworkAddress();
        int maskBits = this.getMask();
        if (maskBits < 0) {
            return networkAddress.equals(ipAddress);
        }
        byte[] networkAddressBytes = networkAddress.getAddress();
        byte[] ipAddressBytes = ipAddress.getAddress();
        if (!networkAddress.getClass().equals(ipAddress.getClass())) {
            return false;
        }
        int maskFullBytes = maskBits / 8;
        int i = 0;
        while (i < maskFullBytes) {
            if (ipAddressBytes[i] != networkAddressBytes[i]) {
                return false;
            }
            ++i;
        }
        int lastMaskBits = maskBits % 8;
        if (lastMaskBits != 0) {
            byte lastMaskByte = (byte)(255 << 8 - lastMaskBits);
            return (networkAddressBytes[maskFullBytes] & lastMaskByte) == (ipAddressBytes[maskFullBytes] & lastMaskByte);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return this.networkAddress.equals(other.getNetworkAddress()) && this.maskBits == other.maskBits;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.networkAddress.toString()) + "/" + this.maskBits;
    }

    public static Subnet fromCidrNotation(String cidrSubnet) throws UnknownHostException {
        int maskBits;
        InetAddress networkID = null;
        int maskIndex = cidrSubnet.lastIndexOf("/");
        if (maskIndex < 0) {
            maskBits = -1;
            networkID = InetAddress.getByName(cidrSubnet);
        } else {
            networkID = InetAddress.getByName(cidrSubnet.substring(0, maskIndex));
            maskBits = Byte.parseByte(cidrSubnet.substring(maskIndex + 1));
        }
        return new Subnet(networkID, maskBits);
    }
}

