/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.control.net;

import com.microej.kf.util.control.net.Bandwidth;
import com.microej.kf.util.control.net.CloseSocket;
import com.microej.kf.util.control.net.OpenSocket;
import com.microej.kf.util.control.net.OpenedSocketsLimitException;
import com.microej.kf.util.control.net.ReadSocket;
import com.microej.kf.util.control.net.Subnet;
import com.microej.kf.util.control.net.WriteSocket;
import com.microej.kf.util.module.SandboxedModule;
import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.basictool.map.PackedMap;
import ej.kf.Kernel;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetResourcesController {
    private int maxConnections;
    private final PackedMap<Subnet, Bandwidth> maxBandwidths;
    private Socket[] currentOpenedConnections;
    private final Logger logger = Logger.getLogger(NetResourcesController.class.getName());

    public NetResourcesController() {
        this.maxBandwidths = new PackedMap();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        this.maxConnections = -1;
        this.currentOpenedConnections = new Socket[0];
        PackedMap<Subnet, Bandwidth> packedMap = this.maxBandwidths;
        synchronized (packedMap) {
            this.maxBandwidths.clear();
        }
    }

    public synchronized void onStart(SandboxedModule module, OpenSocket openSocket) throws SecurityException {
        if (this.maxConnections < 0 || this.currentOpenedConnections.length < this.maxConnections) {
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Opened connections limit reached: only " + this.maxConnections + " connections are allowed to be opened)");
        }
        throw new OpenedSocketsLimitException();
    }

    public synchronized void onEnd(SandboxedModule module, OpenSocket openSocket, boolean withSuccess) {
        if (withSuccess) {
            Kernel.enter();
            this.currentOpenedConnections = (Socket[])ArrayTools.add((Object[])this.currentOpenedConnections, (Object)openSocket.getSocket());
        }
    }

    public synchronized void onStart(SandboxedModule module, CloseSocket closeSocket) throws SecurityException {
    }

    public synchronized void onEnd(SandboxedModule module, CloseSocket closeSocket, boolean withSuccess) {
        if (withSuccess) {
            Kernel.enter();
            this.currentOpenedConnections = (Socket[])ArrayTools.remove((Object[])this.currentOpenedConnections, (Object)closeSocket.getSocket());
        }
    }

    public synchronized int onStart(SandboxedModule module, ReadSocket readSocket) throws SecurityException {
        InetAddress remoteAddress = readSocket.getSocket().getInetAddress();
        Bandwidth bandwidth = this.getMaxBandwidth(remoteAddress);
        if (bandwidth != null) {
            return (int)bandwidth.getReadBandwidthChecker().check(readSocket.getNbBytes(), false);
        }
        return readSocket.getNbBytes();
    }

    public synchronized void onEnd(SandboxedModule module, ReadSocket readSocket, int nbBytesRead) {
        InetAddress remoteAddress;
        Bandwidth bandwidth;
        if (nbBytesRead > 0 && (bandwidth = this.getMaxBandwidth(remoteAddress = readSocket.getSocket().getInetAddress())) != null) {
            bandwidth.getReadBandwidthChecker().update(nbBytesRead);
        }
    }

    public synchronized void onStart(SandboxedModule module, WriteSocket writeSocket) throws SecurityException {
        InetAddress remoteAddress = writeSocket.getSocket().getInetAddress();
        Bandwidth maxBandwidth = this.getMaxBandwidth(remoteAddress);
        if (maxBandwidth != null) {
            maxBandwidth.getWriteBandwidthChecker().check(writeSocket.getNbBytes(), true);
        }
    }

    public synchronized void onEnd(SandboxedModule module, WriteSocket writeSocket, boolean withSuccess) {
        InetAddress remoteAddress;
        Bandwidth maxBandwidth;
        if (withSuccess && (maxBandwidth = this.getMaxBandwidth(remoteAddress = writeSocket.getSocket().getInetAddress())) != null) {
            maxBandwidth.getWriteBandwidthChecker().update(writeSocket.getNbBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Bandwidth getMaxBandwidth(@Nullable InetAddress ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        PackedMap<Subnet, Bandwidth> packedMap = this.maxBandwidths;
        synchronized (packedMap) {
            for (Subnet subnet : this.maxBandwidths.keySet()) {
                if (!subnet.matches(ipAddress)) continue;
                return (Bandwidth)this.maxBandwidths.get((Object)subnet);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBandwidth(Subnet subnet, Bandwidth bandwidth) {
        PackedMap<Subnet, Bandwidth> packedMap = this.maxBandwidths;
        synchronized (packedMap) {
            this.maxBandwidths.put((Object)subnet, (Object)bandwidth);
        }
    }

    public void setMaxOpenedConnections(int maxOpenedConnections) {
        this.maxConnections = maxOpenedConnections;
    }

    public synchronized Socket[] getOpenedConnections() {
        return (Socket[])this.currentOpenedConnections.clone();
    }

    public int getMaxOpenedConnections() {
        return this.maxConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Bandwidth getNetworkMaxBandwidth(Subnet subnet) {
        PackedMap<Subnet, Bandwidth> packedMap = this.maxBandwidths;
        synchronized (packedMap) {
            return (Bandwidth)this.maxBandwidths.get((Object)subnet);
        }
    }
}

