/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util.wifi;

import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.ecom.wifi.AccessPoint;
import ej.ecom.wifi.SecurityMode;

public class AccessPointConfiguration {
    private String passphrase;
    private String ssid;
    private SecurityMode securityMode;
    private AccessPoint accessPoint;

    public AccessPointConfiguration(@NonNull String ssid) throws NullPointerException {
        if (ssid == null) {
            throw new NullPointerException();
        }
        this.ssid = ssid;
    }

    public AccessPointConfiguration(@NonNull AccessPoint accessPoint) throws NullPointerException {
        this(accessPoint.getSSID());
        this.accessPoint = accessPoint;
    }

    public AccessPointConfiguration(@NonNull String ssid, @Nullable String passphrase, @Nullable SecurityMode securityMode) {
        this(ssid);
        this.passphrase = passphrase;
        this.securityMode = securityMode;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(@Nullable String passphrase) {
        this.passphrase = passphrase;
    }

    public String getSSID() {
        String ret = this.ssid;
        AccessPoint point = this.accessPoint;
        if (point != null) {
            ret = point.getSSID();
        }
        return ret;
    }

    public void setSSID(@NonNull String ssid) throws NullPointerException {
        if (ssid == null) {
            throw new NullPointerException();
        }
        this.ssid = ssid;
        AccessPoint point = this.accessPoint;
        if (point != null) {
            point.setSSID(ssid);
        }
    }

    public SecurityMode getSecurityMode() {
        SecurityMode ret = this.securityMode;
        AccessPoint point = this.accessPoint;
        if (point != null) {
            ret = point.getSecurityMode();
        }
        return ret;
    }

    public void setSecurityMode(@Nullable SecurityMode securityMode) {
        this.securityMode = securityMode;
        AccessPoint point = this.accessPoint;
        if (point != null) {
            point.setSecurityMode(securityMode);
        }
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public void setAccessPoint(@Nullable AccessPoint accessPoint) {
        this.accessPoint = accessPoint;
    }
}

