/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.support;

import ej.annotation.Nullable;
import ej.hoka.http.support.ParameterizedArgument;

public class ContentType
extends ParameterizedArgument {
    public static final String KEY_CHARSET = "charset";
    @Nullable
    private String charset;

    public ContentType() {
    }

    public ContentType(String mimeType) {
        this.argument = mimeType;
    }

    public ContentType(String mimeType, String charset) {
        this(mimeType);
        this.charset = charset;
    }

    @Override
    public void endParse() {
        if (this.argument != null) {
            this.argument = this.argument.toLowerCase().intern();
        }
    }

    @Override
    public StringBuilder generate(StringBuilder sb) {
        super.generate(sb);
        if (this.charset != null) {
            sb.append(';').append(KEY_CHARSET).append('=').append(this.charset);
        }
        return sb;
    }

    @Nullable
    public String getCharset() {
        return this.charset;
    }

    @Nullable
    public String getMIMEType() {
        return this.argument;
    }

    @Override
    protected void initializeNbParameters(int nbParameters) {
    }

    @Override
    protected void newParameter(int id, int startKey, int stopKey, int startValue, int stopValue) {
        String currentString = this.currentString;
        assert (currentString != null);
        String key = currentString.substring(startKey, stopKey).intern();
        String value = currentString.substring(startValue, stopValue);
        if (key == KEY_CHARSET) {
            this.charset = value;
        }
    }
}

