/*
 * Decompiled with CFR 0.152.
 */
package ej.net;

import android.net.NetworkCapabilities;
import ej.annotation.Nullable;
import ej.bon.Timer;
import ej.net.PollerConnectivityManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class HttpPollerConnectivityManager
extends PollerConnectivityManager {
    private static final String HTTP = "connectivity.http.";
    public static final String PROPERTY_PORT = "connectivity.http.port";
    public static final String PROPERTY_HOST = "connectivity.http.host";
    public static final String PROPERTY_PAYLOAD = "connectivity.http.payload";
    @Nullable
    static final String DEFAULT_PAYLOAD = System.getProperty("connectivity.http.payload");
    static final int DEFAULT_PORT = Integer.getInteger("connectivity.http.port", 80);
    @Nullable
    private static final String DEFAULT_HOSTNAME = System.getProperty("connectivity.http.host");
    private static final int READ_BUFFER_SIZE = 1024;
    private static final String HOST = "Host: ";
    private static final String GET_HTTP_1_0 = "GET /  HTTP/1.0";
    private static final String NEW_LINE = "\r\n";
    private String payload;
    private String host;
    private int port;

    public HttpPollerConnectivityManager() {
        this.setHttpValues(DEFAULT_HOSTNAME, DEFAULT_PAYLOAD, DEFAULT_PORT);
    }

    public HttpPollerConnectivityManager(Timer timer) {
        super(timer);
        this.setHttpValues(DEFAULT_HOSTNAME, DEFAULT_PAYLOAD, DEFAULT_PORT);
    }

    public HttpPollerConnectivityManager(Timer timer, long delay, long periodWhenAvaialble, long periodWhenLost, long periodWhenInternet) {
        super(timer, delay, periodWhenAvaialble, periodWhenLost, periodWhenInternet);
        this.setHttpValues(DEFAULT_HOSTNAME, DEFAULT_PAYLOAD, DEFAULT_PORT);
    }

    public void setHttpValues(@Nullable String host, @Nullable String payload, int port) {
        if (host == null) {
            throw new IllegalArgumentException();
        }
        this.host = host;
        this.payload = payload != null ? payload : "GET /  HTTP/1.0\r\nHost: " + host + NEW_LINE + NEW_LINE;
        this.port = port;
    }

    @Override
    protected NetworkCapabilities getCapabilities(InetAddress connectedAddress) {
        NetworkCapabilities capabilities = INTERNET_UNCONNECTED;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Socket socket = new Socket(InetAddress.getByName(this.host), this.port, connectedAddress, 0);){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (OutputStream out = socket.getOutputStream();){
                    out.write(this.payload.getBytes());
                    out.flush();
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (InputStream in = socket.getInputStream();){
                        int read;
                        byte[] b = new byte[1024];
                        while ((read = in.read(b)) >= 0) {
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    capabilities = INTERNET_CONNECTED;
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log(-255, e);
        }
        return capabilities;
    }
}

