/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.service;

import com.microej.kf.util.service.SharedServiceRegistry;
import ej.annotation.Nullable;
import ej.basictool.map.AbstractPackedMap;
import ej.basictool.map.PackedMap;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.service.registry.SimpleServiceRegistry;

public class SharedServiceRegistryKF
extends SimpleServiceRegistry
implements SharedServiceRegistry,
FeatureStateListener {
    private final PackedMap<Feature, ClassPackedMap> sharedServicesByFeatures = new PackedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(Class<T> serviceClass, T implementation) {
        Module serviceOwner = Kernel.getOwner(implementation);
        Module contextOwner = Kernel.getContextOwner();
        if (contextOwner != serviceOwner) {
            throw new IllegalStateException();
        }
        if (serviceOwner == Kernel.getInstance()) {
            super.register(serviceClass, implementation);
        } else {
            ClassPackedMap sharedServices;
            PackedMap<Feature, ClassPackedMap> sharedServicesByFeatures;
            this.checkServicePermission(serviceClass, "register");
            Kernel.enter();
            Object object = sharedServicesByFeatures = this.sharedServicesByFeatures;
            synchronized (object) {
                Feature featureOwner;
                if (sharedServicesByFeatures.isEmpty()) {
                    Kernel.addFeatureStateListener((FeatureStateListener)this);
                }
                if ((sharedServices = (ClassPackedMap)((Object)sharedServicesByFeatures.get((Object)(featureOwner = (Feature)serviceOwner)))) == null) {
                    sharedServices = new ClassPackedMap();
                    sharedServicesByFeatures.put((Object)featureOwner, (Object)sharedServices);
                }
            }
            object = sharedServices;
            synchronized (object) {
                sharedServices.put(serviceClass, implementation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregister(Class<T> serviceClass, T implementation) {
        Module serviceOwner = Kernel.getOwner(implementation);
        Module contextOwner = Kernel.getContextOwner();
        if (contextOwner != serviceOwner) {
            throw new IllegalStateException();
        }
        if (serviceOwner == Kernel.getInstance()) {
            super.unregister(serviceClass, implementation);
        } else {
            this.checkServicePermission(serviceClass, "unregister");
            Kernel.enter();
            PackedMap<Feature, ClassPackedMap> sharedServicesByFeatures = this.sharedServicesByFeatures;
            ClassPackedMap sharedServices = (ClassPackedMap)((Object)sharedServicesByFeatures.get((Object)contextOwner));
            if (sharedServices != null) {
                ClassPackedMap classPackedMap = sharedServices;
                synchronized (classPackedMap) {
                    if (sharedServices.get(serviceClass) == implementation) {
                        sharedServices.remove(serviceClass);
                        if (sharedServices.isEmpty()) {
                            PackedMap<Feature, ClassPackedMap> packedMap = sharedServicesByFeatures;
                            synchronized (packedMap) {
                                sharedServicesByFeatures.remove((Object)contextOwner);
                                if (sharedServicesByFeatures.isEmpty()) {
                                    Kernel.removeFeatureStateListener((FeatureStateListener)this);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public <T> T getService(Class<T> serviceClass) {
        T implementation;
        ClassPackedMap sharedServices;
        this.checkServicePermission(serviceClass, "get");
        Module contextOwner = Kernel.getContextOwner();
        if (!Kernel.isInKernelMode() && (sharedServices = (ClassPackedMap)((Object)this.sharedServicesByFeatures.get((Object)contextOwner))) != null && (implementation = this.getSharedService(contextOwner, serviceClass, sharedServices)) != null) {
            return implementation;
        }
        Object kernelService = super.getService(serviceClass);
        if (kernelService != null) {
            return (T)kernelService;
        }
        Kernel.enter();
        for (ClassPackedMap sharedServices2 : this.sharedServicesByFeatures.values()) {
            T implementation2 = this.getSharedService(contextOwner, serviceClass, sharedServices2);
            if (implementation2 == null) continue;
            return implementation2;
        }
        return null;
    }

    @Nullable
    private <T> T getSharedService(Module contextOwner, Class<T> serviceClass, ClassPackedMap sharedServices) {
        Object implementation = sharedServices.get(serviceClass);
        if (implementation != null) {
            if (contextOwner == Kernel.getInstance() && serviceClass.isAssignableFrom(implementation.getClass()) || contextOwner == Kernel.getOwner((Object)implementation)) {
                return (T)implementation;
            }
            if (Kernel.isSharedInterface(serviceClass)) {
                try {
                    return (T)Kernel.bind((Object)implementation, serviceClass, (Feature)((Feature)Kernel.getOwner(serviceClass)));
                }
                catch (IllegalAccessError illegalAccessError) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(@Nullable Feature feature, @Nullable Feature.State previousState) {
        if (feature != null && feature.getState() == Feature.State.STOPPED) {
            PackedMap<Feature, ClassPackedMap> packedMap = this.sharedServicesByFeatures;
            synchronized (packedMap) {
                this.sharedServicesByFeatures.remove((Object)feature);
            }
        }
    }

    class ClassPackedMap
    extends AbstractPackedMap<Class<?>, Object> {
        public ClassPackedMap() {
        }

        public ClassPackedMap(AbstractPackedMap<Class<?>, Object> map) {
            super(map);
        }

        public Object clone() {
            return new ClassPackedMap(this);
        }

        protected boolean isSame(@Nullable Object key, @Nullable Object candidateKey) {
            if (key != null && candidateKey != null) {
                Class keyClass = (Class)key;
                Class candidateKeyClass = (Class)candidateKey;
                String name = keyClass.getName();
                try {
                    name = (String)Kernel.clone((Object)name, (Module)Kernel.getInstance());
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError((Object)e);
                }
                return name.equals(candidateKeyClass.getName());
            }
            return false;
        }

        protected int getKeyHashCode(@Nullable Object wrappedKey) {
            if (wrappedKey != null) {
                String name = ((Class)wrappedKey).getName();
                int hashCode = name.hashCode();
                return hashCode;
            }
            return 0;
        }
    }
}

