/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.HttpURLConnection;

final class HttpsClient
extends HttpClient {
    private static final int httpsPortNumber = 443;
    private SSLSocketFactory sslSocketFactory;

    @Override
    protected int getDefaultPort() {
        return 443;
    }

    HttpsClient(SSLSocketFactory sf, URL url, int connectTimeout) throws IOException {
        this.setSSLSocketFactory(sf);
        this.host = url.getHost();
        this.url = url;
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setConnectTimeout(connectTimeout);
        this.openServer();
    }

    static HttpClient New(SSLSocketFactory sf, URL url, HttpURLConnection httpuc) throws IOException {
        return HttpsClient.New(sf, url, -1, httpuc);
    }

    static HttpClient New(SSLSocketFactory sf, URL url, int connectTimeout, HttpURLConnection httpuc) throws IOException {
        HttpsClient ret = new HttpsClient(sf, url, connectTimeout);
        return ret;
    }

    void setSSLSocketFactory(SSLSocketFactory sf) {
        this.sslSocketFactory = sf;
    }

    SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    protected Socket createSocket() throws IOException {
        try {
            return this.sslSocketFactory.createSocket();
        }
        catch (SocketException se) {
            Throwable t = se.getCause();
            if (t != null && t instanceof UnsupportedOperationException) {
                return super.createSocket();
            }
            throw se;
        }
    }

    @Override
    public void afterConnect() throws IOException, UnknownHostException {
        SSLSocket s = null;
        SSLSocketFactory factory = this.sslSocketFactory;
        try {
            s = (SSLSocket)factory.createSocket(this.serverSocket, this.host, this.port, true);
        }
        catch (IOException ex) {
            try {
                s = (SSLSocket)factory.createSocket(this.host, this.port);
            }
            catch (IOException iOException) {
                throw ex;
            }
        }
        s.startHandshake();
        this.serverSocket = s;
        try {
            this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(String.valueOf(encoding) + " encoding not found");
        }
    }
}

