/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.animation;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.basictool.ThreadUtils;
import ej.bon.Constants;
import ej.bon.Util;
import ej.microui.MicroUI;
import ej.microui.display.Display;
import ej.mwt.animation.Animation;

public class Animator {
    public static final String DEBUG_ANIMATOR_ENABLED_CONSTANT = "ej.mwt.debug.animator.enabled";
    public static final String DEBUG_ANIMATOR_MONITOR_CONSTANT = "ej.mwt.debug.animator.monitor";
    @Nullable
    private static final AnimatorListener ANIMATOR_LISTENER;
    private final Object monitor = new Object();
    private Animation[] animations = new Animation[0];
    private boolean started = false;
    private Runnable tickingRunnable;
    private boolean ticking = false;
    private boolean renderRequested;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !Animator.class.desiredAssertionStatus();
        if (Constants.getBoolean((String)DEBUG_ANIMATOR_ENABLED_CONSTANT)) {
            Object animatorListener;
            Class animatorListenerClass = Constants.getClass((String)DEBUG_ANIMATOR_MONITOR_CONSTANT);
            if (!AnimatorListener.class.isAssignableFrom(animatorListenerClass)) {
                throw new IllegalArgumentException("Class set to ej.mwt.debug.animator.monitor ( " + animatorListenerClass.getName() + " ) does not implement " + AnimatorListener.class.getSimpleName());
            }
            try {
                animatorListener = animatorListenerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Class set to ej.mwt.debug.animator.monitor cannot be instantiated", e);
            }
            if (!$assertionsDisabled && !(animatorListener instanceof AnimatorListener)) {
                throw new AssertionError();
            }
            ANIMATOR_LISTENER = (AnimatorListener)animatorListener;
        } else {
            ANIMATOR_LISTENER = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnimation(Animation animation) {
        Object object = this.monitor;
        synchronized (object) {
            Object[] animations = this.animations;
            if (!ArrayTools.contains((Object[])animations, (Object)animation)) {
                this.animations = (Animation[])ArrayTools.add((Object[])animations, (Object)animation);
                if (!this.started) {
                    this.started = true;
                    this.tickingRunnable = this.createTickRunnable();
                    this.callOnFlushCompleted(this.tickingRunnable);
                }
            }
        }
    }

    public void stopAnimation(Animation animation) {
        if (!MicroUI.isUIThread() || this.ticking) {
            throw new IllegalStateException();
        }
        this.stopAnimationNoCheck(animation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllAnimations() {
        if (!MicroUI.isUIThread() || this.ticking) {
            throw new IllegalStateException();
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.animations.length > 0) {
                this.animations = new Animation[0];
                this.started = false;
                this.tickingRunnable = null;
                Display.getDisplay().cancelCallOnFlushCompleted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAnimationNoCheck(Animation animation) {
        Object object = this.monitor;
        synchronized (object) {
            Animation[] newAnimations = (Animation[])ArrayTools.remove((Object[])this.animations, (Object)animation);
            if (newAnimations != this.animations) {
                this.animations = newAnimations;
                if (newAnimations.length == 0) {
                    this.started = false;
                    this.tickingRunnable = null;
                    Display.getDisplay().cancelCallOnFlushCompleted();
                }
            }
        }
    }

    private void tick(Animation[] animations) {
        long currentTimeMillis = Util.platformTimeMillis();
        Animation[] animationArray = animations;
        int n = animations.length;
        int n2 = 0;
        while (n2 < n) {
            Animation animation = animationArray[n2];
            if (!$assertionsDisabled && animation == null) {
                throw new AssertionError();
            }
            try {
                if (!animation.tick(currentTimeMillis)) {
                    this.stopAnimationNoCheck(animation);
                }
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
                this.stopAnimationNoCheck(animation);
            }
            ++n2;
        }
    }

    private void runTick(Runnable runnable) {
        Animation[] animations = this.animations;
        if (Constants.getBoolean((String)DEBUG_ANIMATOR_ENABLED_CONSTANT)) {
            this.renderRequested = false;
        }
        this.ticking = true;
        this.tick(animations);
        this.ticking = false;
        if (this.started) {
            if (Constants.getBoolean((String)DEBUG_ANIMATOR_ENABLED_CONSTANT) && !this.renderRequested) {
                if (!$assertionsDisabled && ANIMATOR_LISTENER == null) {
                    throw new AssertionError();
                }
                ANIMATOR_LISTENER.onVoidTick(animations);
            }
            if (this.tickingRunnable == runnable) {
                this.callOnFlushCompleted(runnable);
            }
        }
    }

    private void callOnFlushCompleted(Runnable runnable) {
        Display display = Display.getDisplay();
        display.callOnFlushCompleted(runnable);
        display.requestFlush();
    }

    private Runnable createTickRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                Animator.this.runTick(this);
            }
        };
    }

    public void indicateRenderRequested() {
        this.renderRequested = true;
    }

    public static interface AnimatorListener {
        public void onVoidTick(Animation[] var1);
    }
}

