/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import ej.annotation.Nullable;
import ej.bon.Constants;
import ej.microui.MicroUI;
import ej.microui.display.Display;
import ej.microui.display.Displayable;
import ej.microui.display.GraphicsContext;
import ej.mwt.Widget;
import ej.mwt.animation.Animator;
import ej.mwt.event.EventDispatcher;
import ej.mwt.event.PointerEventDispatcher;
import ej.mwt.render.DefaultRenderPolicy;
import ej.mwt.render.RenderPolicy;
import ej.mwt.stylesheet.Stylesheet;
import ej.mwt.stylesheet.VoidStylesheet;

public class Desktop
extends Displayable {
    private final Animator animator = new Animator();
    @Nullable
    private EventDispatcher eventDispatcher;
    @Nullable
    private RenderPolicy renderPolicy;
    @Nullable
    private Widget widget;
    private Stylesheet stylesheet = new VoidStylesheet();
    private boolean attached;

    protected EventDispatcher createEventDispatcher() {
        return new PointerEventDispatcher(this);
    }

    @Nullable
    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    protected RenderPolicy createRenderPolicy() {
        return new DefaultRenderPolicy(this);
    }

    void requestRender(Widget widget, int x, int y, int width, int height) {
        if (Constants.getBoolean((String)"ej.mwt.debug.animator.enabled")) {
            this.animator.indicateRenderRequested();
        }
        RenderPolicy renderPolicy = this.renderPolicy;
        assert (renderPolicy != null);
        renderPolicy.requestRender(widget, x, y, width, height);
    }

    public void setWidget(@Nullable Widget widget) {
        Widget previousWidget = this.widget;
        if (previousWidget != null) {
            previousWidget.resetParent();
        }
        if (widget != null) {
            if (widget.parent != null) {
                throw new IllegalArgumentException();
            }
            widget.setParent((Object)this, this.isShown());
        }
        this.widget = widget;
    }

    @Nullable
    public Widget getWidget() {
        return this.widget;
    }

    public void requestLayOut() {
        if (this.isShown()) {
            MicroUI.callSerially((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Desktop.this.isShown()) {
                        Desktop.this.layOut();
                        Desktop.this.showWidget();
                    }
                }
            });
            this.requestRender();
        }
    }

    public void requestRender() {
        if (Constants.getBoolean((String)"ej.mwt.debug.animator.enabled")) {
            this.animator.indicateRenderRequested();
        }
        RenderPolicy renderPolicy = this.renderPolicy;
        assert (renderPolicy != null);
        Display display = Display.getDisplay();
        int width = display.getWidth();
        int height = display.getHeight();
        Widget widget = this.widget;
        if (widget != null) {
            renderPolicy.requestRender(widget, 0, 0, width, height);
        }
    }

    void layOut() {
        assert (this.attached) : "This desktop cannot be laid out since it is not attached.";
        Widget widget = this.widget;
        if (widget != null) {
            Display display = Display.getDisplay();
            int width = display.getWidth();
            int height = display.getHeight();
            widget.computeOptimalSize(width, height);
            widget.layOut(0, 0, width, height);
        }
    }

    public boolean isShown() {
        return MicroUI.isStarted() && Display.getDisplay().isShown((Displayable)this);
    }

    public void requestShow() {
        Display.getDisplay().requestShow((Displayable)this);
    }

    public void requestHide() {
        Display.getDisplay().requestHide((Displayable)this);
    }

    protected void onShown() {
        EventDispatcher eventDispatcher = this.createEventDispatcher();
        eventDispatcher.initialize();
        this.eventDispatcher = eventDispatcher;
        this.renderPolicy = this.createRenderPolicy();
        this.setAttached();
        this.showWidget();
    }

    protected void onHidden() {
        this.setDetached();
        EventDispatcher eventDispatcher = this.eventDispatcher;
        if (eventDispatcher != null) {
            eventDispatcher.dispose();
            this.eventDispatcher = null;
        }
        this.animator.stopAllAnimations();
    }

    private void showWidget() {
        Widget widget = this.widget;
        if (widget != null) {
            widget.setShown();
        }
    }

    public void setAttached() {
        if (!this.attached) {
            this.attached = true;
            Widget widget = this.widget;
            if (widget != null) {
                widget.setAttached();
                widget.updateStyle();
            }
            this.layOut();
        }
    }

    public void setDetached() {
        this.attached = false;
        Widget widget = this.widget;
        if (widget != null) {
            widget.setDetached();
        }
    }

    public boolean isAttached() {
        return this.attached;
    }

    public boolean handleEvent(int event) {
        EventDispatcher eventDispatcher = this.eventDispatcher;
        if (eventDispatcher != null) {
            return eventDispatcher.dispatchEvent(event);
        }
        return false;
    }

    public void renderWidget(GraphicsContext g, Widget widget) {
        assert (this.containsWidget(widget)) : "This desktop cannot render the given widget (" + Widget.printClassname(widget) + ") since it is not its child.";
        widget.paint(g);
    }

    protected void render(GraphicsContext g) {
        RenderPolicy renderPolicy = this.renderPolicy;
        assert (renderPolicy != null);
        renderPolicy.renderDesktop();
    }

    @Nullable
    public Widget getWidgetAt(int x, int y) {
        Widget widget = this.widget;
        if (widget != null) {
            return widget.getWidgetAt(x, y);
        }
        return null;
    }

    public boolean containsWidget(Widget widget) {
        return this.widget != null && this.widget.containsWidget(widget);
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public void setStylesheet(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }
}

