/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.body;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.body.BodyParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class StringBodyParser
implements BodyParser {
    private static final int BUFFSIZE = 512;
    private String body;
    private String[] parts;
    private boolean isMultipartFormEncoded;

    @Override
    public void parseBody(HTTPRequest httpRequest) throws IOException {
        InputStream inputStream = httpRequest.getStream();
        String contentType = httpRequest.getHeaderField("content-type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            String boundary = contentType.substring(contentType.indexOf(59) + 1);
            boundary = boundary.substring(boundary.indexOf("boundary=") + "boundary=".length());
            String multipartBody = StringBodyParser.read(inputStream);
            this.parts = StringBodyParser.split(multipartBody, boundary);
            this.isMultipartFormEncoded = true;
        } else {
            this.body = StringBodyParser.read(inputStream);
        }
    }

    public String getBody() {
        return this.body;
    }

    public boolean isMultipartFormEncoded() {
        return this.isMultipartFormEncoded;
    }

    public String[] parts() {
        return this.parts;
    }

    public String toString() {
        return this.body;
    }

    private static String read(InputStream stream) throws IOException {
        StringBuilder body = new StringBuilder(stream.available());
        int readLen = -1;
        char[] buff = new char[512];
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            while ((readLen = reader.read(buff)) != -1) {
                body.append(buff, 0, readLen);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        buff = null;
        return body.toString();
    }

    private static String[] split(String toSplit, String separator) {
        int index = toSplit.indexOf(separator);
        ArrayList<String> parts = new ArrayList<String>();
        while (index > -1) {
            int indexEnd = toSplit.indexOf(separator, index + separator.length());
            if (indexEnd != -1) {
                parts.add(toSplit.substring(index + separator.length() + 2, indexEnd - 4));
            } else {
                parts.add(toSplit.substring(index + separator.length() + 2, toSplit.length() - 2));
            }
            index = indexEnd;
        }
        return parts.toArray(new String[parts.size()]);
    }
}

