/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.container;

import ej.annotation.Nullable;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Size;

public class SimpleDock
extends Container {
    private boolean orientation;
    @Nullable
    private Widget first;
    @Nullable
    private Widget center;
    @Nullable
    private Widget last;

    public SimpleDock(boolean orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(boolean orientation) {
        this.orientation = orientation;
    }

    public boolean getOrientation() {
        return this.orientation;
    }

    public void setFirstChild(Widget child) {
        Widget first = this.first;
        if (first != null) {
            this.removeChild(first);
        }
        this.first = child;
        this.addChild(child);
    }

    @Nullable
    public Widget getFirstChild() {
        return this.first;
    }

    public void setLastChild(Widget child) {
        Widget last = this.last;
        if (last != null) {
            this.removeChild(last);
        }
        this.last = child;
        this.addChild(child);
    }

    @Nullable
    public Widget getLastChild() {
        return this.last;
    }

    public void setCenterChild(Widget child) {
        Widget center = this.center;
        if (center != null) {
            this.removeChild(center);
        }
        this.center = child;
        this.addChild(child);
    }

    @Nullable
    public Widget getCenterChild() {
        return this.center;
    }

    public void removeChild(Widget widget) {
        if (widget == this.first) {
            this.first = null;
        } else if (widget == this.last) {
            this.last = null;
        } else if (widget == this.center) {
            this.center = null;
        }
        super.removeChild(widget);
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.first = null;
        this.last = null;
        this.center = null;
    }

    protected void computeContentOptimalSize(Size size) {
        int height;
        int width;
        int centerOptimalHeight;
        int centerOptimalWidth;
        int lastOptimalHeight;
        int lastOptimalWidth;
        int firstOptimalHeight;
        int firstOptimalWidth;
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            size.setSize(0, 0);
            return;
        }
        boolean isHorizontal = this.isHorizontal();
        int widthHint = size.getWidth();
        int heightHint = size.getHeight();
        Widget first = this.first;
        if (first != null) {
            this.computeChildOptimalSize(first, widthHint, heightHint);
            firstOptimalWidth = first.getWidth();
            firstOptimalHeight = first.getHeight();
        } else {
            firstOptimalWidth = 0;
            firstOptimalHeight = 0;
        }
        Widget last = this.last;
        if (last != null) {
            this.computeChildOptimalSize(last, widthHint, heightHint);
            lastOptimalWidth = last.getWidth();
            lastOptimalHeight = last.getHeight();
        } else {
            lastOptimalWidth = 0;
            lastOptimalHeight = 0;
        }
        Widget center = this.center;
        int centerWidth = widthHint != 0 && isHorizontal ? SimpleDock.computeCenterSize(widthHint, firstOptimalWidth, lastOptimalWidth) : widthHint;
        int centerHeight = heightHint != 0 && !isHorizontal ? SimpleDock.computeCenterSize(heightHint, firstOptimalHeight, lastOptimalHeight) : heightHint;
        if (center != null) {
            this.computeChildOptimalSize(center, centerWidth, centerHeight);
            centerOptimalWidth = center.getWidth();
            centerOptimalHeight = center.getHeight();
        } else {
            centerOptimalWidth = 0;
            centerOptimalHeight = 0;
        }
        if (isHorizontal) {
            width = firstOptimalWidth + centerOptimalWidth + lastOptimalWidth;
            height = SimpleDock.max(firstOptimalHeight, centerOptimalHeight, lastOptimalHeight);
        } else {
            width = SimpleDock.max(firstOptimalWidth, centerOptimalWidth, lastOptimalWidth);
            height = firstOptimalHeight + centerOptimalHeight + lastOptimalHeight;
        }
        size.setSize(width, height);
    }

    protected void layOutChildren(int contentWidth, int contentHeight) {
        Widget center;
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            return;
        }
        boolean isHorizontal = this.isHorizontal();
        Widget first = this.first;
        Widget last = this.last;
        int firstWidth = contentWidth;
        int firstHeight = contentHeight;
        int lastWidth = contentWidth;
        int lastHeight = contentHeight;
        if (isHorizontal) {
            firstWidth = this.getWidth(first);
            lastWidth = this.getWidth(last);
        } else {
            firstHeight = this.getHeight(first);
            lastHeight = this.getHeight(last);
        }
        if (first != null) {
            this.layOutChild(first, 0, 0, firstWidth, firstHeight);
        }
        if (last != null) {
            this.layOutChild(last, contentWidth - lastWidth, contentHeight - lastHeight, lastWidth, lastHeight);
        }
        if ((center = this.center) != null) {
            if (isHorizontal) {
                int centerWidth = SimpleDock.computeCenterSize(contentWidth, firstWidth, lastWidth);
                this.layOutChild(center, firstWidth, 0, centerWidth, contentHeight);
            } else {
                int centerHeight = SimpleDock.computeCenterSize(contentHeight, firstHeight, lastHeight);
                this.layOutChild(center, 0, firstHeight, contentWidth, centerHeight);
            }
        }
    }

    private boolean isHorizontal() {
        return this.orientation;
    }

    private int getWidth(@Nullable Widget widget) {
        if (widget == null) {
            return 0;
        }
        return widget.getWidth();
    }

    private int getHeight(@Nullable Widget widget) {
        if (widget == null) {
            return 0;
        }
        return widget.getHeight();
    }

    private static int computeCenterSize(int totalSize, int firstSize, int lastSize) {
        return Math.max(0, totalSize - firstSize - lastSize);
    }

    private static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }
}

