/*
 * Decompiled with CFR 0.152.
 */
package ej.util.message.basic;

import ej.util.message.MessageBuilder;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class BasicMessageBuilder
implements MessageBuilder {
    public static final BasicMessageBuilder INSTANCE = new BasicMessageBuilder();

    @Override
    public String buildMessage(char level, String category, int id) {
        StringBuilder messageBuilder = new StringBuilder();
        this.appendMessageInternal(messageBuilder, level, category, id);
        return messageBuilder.toString();
    }

    @Override
    public String buildMessage(char level, String category, int id, Object ... arguments) {
        StringBuilder messageBuilder = new StringBuilder();
        this.appendMessageInternal(messageBuilder, level, category, id);
        this.appendArgumentsInternal(messageBuilder, arguments);
        return messageBuilder.toString();
    }

    @Override
    public String buildMessage(char level, String category, int id, Throwable t) {
        StringBuilder messageBuilder = new StringBuilder();
        this.appendMessageInternal(messageBuilder, level, category, id);
        this.appendThrowableInternal(messageBuilder, t);
        return messageBuilder.toString();
    }

    @Override
    public String buildMessage(char level, String category, int id, Throwable t, Object ... arguments) {
        StringBuilder messageBuilder = new StringBuilder();
        this.appendMessageInternal(messageBuilder, level, category, id);
        this.appendArgumentsInternal(messageBuilder, arguments);
        this.appendThrowableInternal(messageBuilder, t);
        return messageBuilder.toString();
    }

    private StringBuilder appendMessageInternal(StringBuilder messageBuilder, char level, String category, int id) {
        return messageBuilder.append(category).append(':').append(level).append('=').append(id);
    }

    private StringBuilder appendThrowableInternal(StringBuilder messageBuilder, Throwable t) {
        messageBuilder.append('\n');
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(stream));
        messageBuilder.append(new String(stream.toByteArray()));
        return messageBuilder;
    }

    private StringBuilder appendArgumentsInternal(StringBuilder messageBuilder, Object ... arguments) {
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument = objectArray[n2];
            messageBuilder.append(' ').append(argument);
            ++n2;
        }
        return messageBuilder;
    }
}

