/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkCapabilities;
import ej.annotation.Nullable;
import ej.basictool.ArrayTools;

public class NetworkRequest {
    public final NetworkCapabilities networkCapabilities;
    public final int requestId;
    public final int legacyType;

    private NetworkRequest(NetworkCapabilities nc, int legacyType, int rId) {
        if (nc == null) {
            throw new NullPointerException();
        }
        this.requestId = rId;
        this.networkCapabilities = nc;
        this.legacyType = legacyType;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof NetworkRequest)) {
            return false;
        }
        NetworkRequest that = (NetworkRequest)obj;
        return that.legacyType == this.legacyType && that.requestId == this.requestId && that.networkCapabilities.equals(this.networkCapabilities);
    }

    public int hashCode() {
        return this.requestId + this.legacyType * 1013 + this.networkCapabilities.hashCode() * 1051;
    }

    /* synthetic */ NetworkRequest(NetworkCapabilities networkCapabilities, int n, int n2, NetworkRequest networkRequest) {
        this(networkCapabilities, n, n2);
    }

    public static class Builder {
        private final NetworkCapabilities mNetworkCapabilities = new NetworkCapabilities();

        public synchronized Builder addCapability(int capability) {
            if (!this.mNetworkCapabilities.hasCapability(capability)) {
                this.mNetworkCapabilities.setCapabilities(ArrayTools.add((int[])this.mNetworkCapabilities.getCapabilities(), (int)capability));
            }
            return this;
        }

        public synchronized Builder removeCapability(int capability) {
            if (this.mNetworkCapabilities.hasCapability(capability)) {
                this.mNetworkCapabilities.setCapabilities(ArrayTools.remove((int[])this.mNetworkCapabilities.getCapabilities(), (int)capability));
            }
            return this;
        }

        public NetworkRequest build() {
            return new NetworkRequest(this.mNetworkCapabilities, 0, 0, null);
        }
    }
}

