/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.HeapDoubleBufferR;

class HeapDoubleBuffer
extends DoubleBuffer {
    HeapDoubleBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new double[cap], 0);
    }

    HeapDoubleBuffer(double[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapDoubleBuffer(double[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public DoubleBuffer slice() {
        double[] hb = this.hb;
        assert (hb != null);
        return new HeapDoubleBuffer(hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public DoubleBuffer duplicate() {
        double[] hb = this.hb;
        assert (hb != null);
        return new HeapDoubleBuffer(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        double[] hb = this.hb;
        assert (hb != null);
        return new HeapDoubleBufferR(hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public double get() {
        double[] hb = this.hb;
        assert (hb != null);
        return hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public double get(int i) {
        double[] hb = this.hb;
        assert (hb != null);
        return hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public DoubleBuffer get(double[] dst, int offset, int length) {
        HeapDoubleBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        double[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public DoubleBuffer put(double x) {
        double[] hb = this.hb;
        assert (hb != null);
        hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public DoubleBuffer put(int i, double x) {
        double[] hb = this.hb;
        assert (hb != null);
        hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public DoubleBuffer put(double[] src, int offset, int length) {
        HeapDoubleBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        double[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(src, offset, hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public DoubleBuffer put(DoubleBuffer src) {
        double[] hb = this.hb;
        assert (hb != null);
        if (src instanceof HeapDoubleBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapDoubleBuffer sb = (HeapDoubleBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            double[] srcHb = sb.hb;
            assert (srcHb != null);
            System.arraycopy(srcHb, sb.ix(sb.position()), hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public DoubleBuffer compact() {
        double[] hb = this.hb;
        assert (hb != null);
        System.arraycopy(hb, this.ix(this.position()), hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

