/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.server;

import ej.annotation.NonNull;
import ej.basictool.ArrayTools;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothDevice;
import ej.bluetooth.BluetoothUuid;
import ej.bluetooth.util.server.BasicServerDescriptor;
import ej.bluetooth.util.server.CCCDescriptor;
import ej.bluetooth.util.server.NotificationCallback;

public class BasicServerCharacteristic
extends BluetoothCharacteristic
implements NotificationCallback {
    private BasicServerDescriptor[] descriptors = new BasicServerDescriptor[0];
    private CCCDescriptor cccDescriptor;

    public BasicServerCharacteristic(@NonNull BluetoothUuid uuid, int properties, int permissions) {
        super(uuid, properties, permissions);
        if ((properties & 0x30) != 0) {
            this.cccDescriptor = new CCCDescriptor();
            this.addDescriptor(this.cccDescriptor);
        }
    }

    public void addDescriptor(@NonNull BasicServerDescriptor descriptor) {
        super.addDescriptor((BluetoothDescriptor)descriptor);
        this.descriptors = (BasicServerDescriptor[])ArrayTools.add((Object[])this.descriptors, (Object)descriptor);
    }

    public BasicServerDescriptor[] getServerDescriptors() {
        return this.descriptors;
    }

    @Override
    public void onWriteRequest(BluetoothDevice device, byte[] value) {
    }

    @Override
    public void onReadRequest(BluetoothDevice device) {
    }

    @Override
    public void onNotify(BluetoothDevice device) {
    }

    private boolean shouldNotify(BluetoothDevice device) {
        return this.cccDescriptor != null && this.cccDescriptor.shouldNotify(device);
    }

    void notify(BluetoothDevice[] devices) {
        BluetoothDevice[] bluetoothDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            BluetoothDevice bluetoothDevice = bluetoothDeviceArray[n2];
            if (this.shouldNotify(bluetoothDevice)) {
                this.onNotify(bluetoothDevice);
            }
            ++n2;
        }
    }
}

