/*
 * Decompiled with CFR 0.152.
 */
package ej.restserver.endpoint;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.support.MIMEUtils;
import ej.restserver.RestEndpoint;
import ej.restserver.RestResponse;
import java.io.InputStream;
import java.util.Map;

public class ResourceRestEndpoint
extends RestEndpoint {
    private String mimetype;
    protected String resource;

    public ResourceRestEndpoint(String uri, String resource) {
        this(uri, resource, null);
    }

    public ResourceRestEndpoint(String uri, String resource, String mimetype) {
        super(uri);
        this.mimetype = mimetype;
        if (resource == null) {
            throw new NullPointerException();
        }
        this.resource = resource;
    }

    protected InputStream getResourceAsStream() {
        return this.getClass().getResourceAsStream(this.resource);
    }

    protected HTTPResponse getResourceResponse() {
        InputStream resourceAsStream = this.getResourceAsStream();
        if (resourceAsStream == null) {
            return HTTPResponse.RESPONSE_NOT_FOUND;
        }
        String mimeType = this.mimetype;
        if (mimeType == null && (mimeType = MIMEUtils.getMIMEType((String)this.resource)) == null) {
            mimeType = "application/octet-stream";
        }
        return new RestResponse("200 OK", mimeType, resourceAsStream);
    }

    @Override
    public HTTPResponse get(HTTPRequest request, Map<String, String> headers, Map<String, String> parameters) {
        return this.getResourceResponse();
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }
}

