/*
 * Decompiled with CFR 0.152.
 */
package ej.rest.web;

import ej.jsonpath.parser.JSONPathCompiler;
import ej.jsonpath.parser.ParseException;
import ej.jsonpath.parser.SimpleCharStream;
import ej.rest.web.JSONResource;
import ej.rest.web.PathQuery;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class JSONPathQuery
extends PathQuery<JSONResource, Object> {
    private JSONPathCompiler compiler;
    private final String expr;
    private static Logger log = Logger.getLogger(JSONPathQuery.class.getName());

    public JSONPathQuery(String anExpression) {
        this.expr = anExpression;
    }

    @Override
    Object eval(JSONResource resource) throws JSONException, ParseException, IOException {
        JSONObject json = resource.object();
        log.fine("JSON Received:" + json);
        Object result = this.getCompiler().json().eval(json);
        return result;
    }

    protected JSONPathCompiler getCompiler() throws ParseException {
        if (this.compiler == null) {
            SimpleCharStream charStream = new SimpleCharStream(new ByteArrayInputStream(this.expr.getBytes()));
            this.compiler = new JSONPathCompiler(charStream);
        }
        return this.compiler;
    }
}

